(ns com.farmlogs.conduit.async
  (:require [clojure.core.async :as a]))

(defn maybe-throw
  [value]
  (if (instance? Throwable value)
    (throw value)
    value))

(def <?? (comp maybe-throw a/<!!))

(defmacro <?
  [expr]
  `(let [result# (a/<! ~expr)]
     (maybe-throw result#)))

(defmacro try-thread
  [& body]
  `(a/thread
     (try ~@body (catch Throwable t t))))

(defmacro try-go
  [& body]
  `(a/go
     (try ~@body (catch Throwable t t))))
