/*
 * Decompiled with CFR 0.152.
 */
package exoscale.vinyl;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexableRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.record.provider.foundationdb.SplitHelper;
import com.apple.foundationdb.record.provider.foundationdb.indexes.StandardIndexMaintainer;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import exoscale.vinyl.Demostore;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class RefcountIndexMaintainer
extends StandardIndexMaintainer {
    public static byte[] EMPTY_VALUE = new byte[0];
    public static byte[] LITTLE_ENDIAN_INT64_ONE = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    private final Subspace refCountSubspace = this.getIndexSubspace().subspace(Tuple.from((Object[])new Object[]{"refcount"}));
    private final Subspace zeroSubspace = this.getIndexSubspace().subspace(Tuple.from((Object[])new Object[]{"zero"}));

    protected RefcountIndexMaintainer(IndexMaintainerState indexMaintainerState) {
        super(indexMaintainerState);
    }

    public Object toRecord(FDBIndexableRecord<? extends Message> fDBIndexableRecord) {
        String string;
        return switch (string = fDBIndexableRecord.getRecordType().getName()) {
            case "Invoice" -> Demostore.Invoice.newBuilder().mergeFrom(fDBIndexableRecord.getRecord()).build();
            case "Object" -> Demostore.Object.newBuilder().mergeFrom(fDBIndexableRecord.getRecord()).build();
            default -> throw new IllegalArgumentException("Unsupported record type");
        };
    }

    @Nonnull
    public <M extends Message> CompletableFuture<Void> update(FDBIndexableRecord<M> fDBIndexableRecord, FDBIndexableRecord<M> fDBIndexableRecord2) {
        Transaction transaction = this.state.transaction;
        if (fDBIndexableRecord2 != null && fDBIndexableRecord == null) {
            Object object = this.toRecord(fDBIndexableRecord2);
            if (object instanceof Demostore.Invoice) {
                Demostore.Invoice invoice = (Demostore.Invoice)object;
                invoice.getLinesList().forEach(invoiceLine -> this.increment(transaction, invoiceLine.getProduct()));
            } else {
                Demostore.Object object2 = (Demostore.Object)object;
                this.increment(transaction, object2.getBucket());
            }
        } else if (fDBIndexableRecord2 == null && fDBIndexableRecord != null) {
            Object object = this.toRecord(fDBIndexableRecord);
            if (object instanceof Demostore.Invoice) {
                Demostore.Invoice invoice = (Demostore.Invoice)object;
                for (Demostore.InvoiceLine invoiceLine2 : invoice.getLinesList()) {
                    this.decrement(transaction, invoiceLine2.getProduct());
                }
            } else {
                Demostore.Object object3 = (Demostore.Object)object;
                this.decrement(transaction, object3.getBucket());
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private void increment(Transaction transaction, Object object) {
        try {
            byte[] byArray = this.refCountSubspace.pack(object);
            transaction.mutate(MutationType.ADD, byArray, LITTLE_ENDIAN_INT64_ONE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void decrement(Transaction transaction, Object object) {
        try {
            byte[] byArray = this.refCountSubspace.pack(object);
            byte[] byArray2 = (byte[])transaction.get(byArray).get();
            long l = ByteArrayUtil.decodeInt((byte[])byArray2) - 1L;
            if (l == 0L) {
                transaction.clear(this.refCountSubspace.pack(object));
                transaction.set(this.zeroSubspace.pack(object), EMPTY_VALUE);
            } else {
                transaction.set(byArray, ByteArrayUtil.encodeInt((long)l));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Nonnull
    public RecordCursor<IndexEntry> scan(@Nonnull IndexScanType indexScanType, @Nonnull TupleRange tupleRange, byte[] byArray, @Nonnull ScanProperties scanProperties) {
        KeyValueCursor keyValueCursor = KeyValueCursor.Builder.withSubspace((Subspace)this.getIndexSubspace()).setContext(this.state.context).setRange(tupleRange).setContinuation(byArray).setScanProperties(scanProperties).build();
        return keyValueCursor.map(keyValue -> {
            this.state.store.countKeyValue((StoreTimer.Count)FDBStoreTimer.Counts.LOAD_INDEX_KEY, (StoreTimer.Count)FDBStoreTimer.Counts.LOAD_INDEX_KEY_BYTES, (StoreTimer.Count)FDBStoreTimer.Counts.LOAD_INDEX_VALUE_BYTES, keyValue);
            return this.unpackKeyValue((KeyValue)keyValue);
        });
    }

    public boolean isIdempotent() {
        return false;
    }

    @Nonnull
    protected IndexEntry unpackKeyValue(@Nonnull KeyValue keyValue) {
        if (Arrays.equals(keyValue.getValue(), EMPTY_VALUE)) {
            return new IndexEntry(this.state.index, SplitHelper.unpackKey((Subspace)this.getIndexSubspace(), (KeyValue)keyValue), Tuple.from((Object[])new Object[]{0}));
        }
        return new IndexEntry(this.state.index, SplitHelper.unpackKey((Subspace)this.getIndexSubspace(), (KeyValue)keyValue), Tuple.from((Object[])new Object[]{ByteArrayUtil.decodeInt((byte[])keyValue.getValue())}));
    }
}

