(ns exoscale.mania.cli
  (:require [clojure.spec.alpha :as s]
            [clojure.tools.cli :as cli]
            [clojure.string :as str]
            [exoscale.mania.repl :as repl]))

(s/def :exoscale.mania.cli/options (s/coll-of (s/coll-of any?))) ; could be refined

(def default-opts {:exoscale.mania.cli/options
                   [["-f" "--file <FILE>" "Configuration file path"
                     :id :exoscale.mania.config/file]
                    ["-p" "--profile <PROFILE_ID>" "aero profile"
                     :id :exoscale.mania.config/profile
                     :parse-fn keyword]
                    ["-r" "--repl <ADDRESS:PORT>" "nREPL server address"
                     :parse-fn repl/parse-repl-uri
                     :assoc-fn (fn [options _ repl]
                                 (merge options repl))]
                    ["-x" "--xspec" "Verbose spec explain"
                     :id :exoscale.mania.config/verbose-spec-error]
                    ["-v" "--version" "Show version"
                     :default false]
                    ["-h" "--help" "Show Help"
                     :default false]]
                   :exoscale.mania.config/type :aero
                   ;; should be overridden by user, but just in case
                   :exoscale.mania.config/spec
                   (s/keys :req-un [:exoscale.mania.config/reporter
                                    :exoscale.mania.config/logging])})

(defn parse-args
  [{:exoscale.mania.cli/keys [options]} args-raw]
  (let [args (cli/parse-opts args-raw options)]
    (when-let [errors (:errors args)]
      (println (format "CLI errors found: %s"
                       (str/join ", " errors)))
      (System/exit 1))
    args))
