(defproject com.exoscale/mania "1.0.5"

  :description "Our generic service/program entrypoints"

  :url "https://github.com/exoscale/mania"

  :license {:name "ISC"}

  :dependencies [[org.clojure/clojure "1.11.0"]
                 [org.clojure/tools.logging "1.2.4"]
                 [org.clojure/tools.cli "1.0.206"]
                 [exoscale/cloak "0.1.8"]
                 [exoscale/coax "1.0.0-alpha14"]
                 [com.exoscale/lingo "1.0.0-alpha20"]
                 [spootnik/signal "0.2.4"]
                 [aero "1.1.6"]
                 [com.stuartsierra/component "1.1.0"]
                 [nrepl "0.9.0"]]

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]

  :plugins [[lein-cljfmt "0.6.7"
             :exclusions [com.google.errorprone/error_prone_annotations
                          org.clojure/clojure
                          com.google.code.findbugs/jsr305
                          com.fasterxml.jackson.core/jackson-core]]]

  :profiles {:dev {:resource-paths ["test/resources"]
                   :dependencies [[org.slf4j/slf4j-simple "1.7.36"]]
                   :plugins [[lein-with-env-vars "0.2.0"]]
                   :hooks [leiningen.with-env-vars/auto-inject]
                   :env-vars {:TEST_ENV_FILE "test/resources/env-file-test"}}}

  :pedantic? :warn

  :global-vars {*warn-on-reflection* true})
