(ns exoscale.mania.secret
  (:require [aero.core :as aero]
            [exoscale.cloak :as c]))

(defmethod aero/reader 'secret
  [_ _ value]
  (c/mask value))

(def ^:deprecated mask c/mask)
(def ^:deprecated unmask c/unmask)

(defprotocol SecretsProvider
  "Abstraction over a secrets provider, may be backed by a file, vault, etc.
  Providers should implement reloadable protocol where applicable."
  :extend-via-metadata true
  (lookup [this] [this k] "Lookup a secret object, optionally by `k`"))
