(defproject com.exoscale/mania "1.0.0-alpha3"

  :description "Our generic service/program entrypoints"

  :url "https://github.com/exoscale/mania"

  :license {:name "ISC"}

  :dependencies [[org.clojure/clojure "1.10.3"]
                 [org.clojure/tools.logging "1.1.0"]
                 [org.clojure/tools.cli "1.0.206"]
                 [exoscale/cloak "0.1.8"]
                 [exoscale/coax "1.0.0-alpha14"]
                 [exoscale/yummy "0.2.11"]
                 [spootnik/signal "0.2.4"]
                 [exoscale/reporter "0.1.55"]
                 [spootnik/unilog "0.7.28" :exclusions [com.fasterxml.jackson.core/jackson-annotations]]
                 [aero "1.1.6"]
                 [com.stuartsierra/component "1.0.0"]
                 [com.fasterxml.jackson.dataformat/jackson-dataformat-cbor "2.12.0"]
                 [com.fasterxml.jackson.dataformat/jackson-dataformat-smile "2.12.0"]
                 [com.fasterxml.jackson.core/jackson-core "2.12.0"]
                 [com.fasterxml.jackson.core/jackson-databind "2.12.0"]
                 [nrepl "0.7.0"]]

  :jvm-opts ["-Dio.netty.tryReflectionSetAccessible=false"]

  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]

  :plugins [[lein-cljfmt "0.6.7"
             :exclusions [com.google.errorprone/error_prone_annotations
                          org.clojure/clojure
                          com.google.code.findbugs/jsr305
                          com.fasterxml.jackson.core/jackson-core]]]

  :profiles {:dev {:resource-paths ["test/resources"]
                   :jvm-opts ["-Dlogback.configurationFile=stdout.logback.xml"]}}

  :pedantic? :warn

  :global-vars {*warn-on-reflection* true})
