(ns ltof.core
  (:require
   [clojure.java.io :as io]
   [clojure.string  :as string]))

(defn ltof
  "Split file f line by line into other files
   named by line-fn function."
  {:added "0.1.0"}
  ([f line-fn]
   (ltof f line-fn {}))
  ([f line-fn opts]
   (with-open [rdr (io/reader f)]
     (let [prefix (:prefix opts)
           suffix (:suffix opts)
           skip-header (or (:skip-header opts) 0)

           {:keys [headers grouped]}
           (loop [lines       (line-seq rdr)
                  skip-header skip-header
                  headers     []
                  grouped     {}]
             (if (> skip-header 0)
               (recur (next lines) (dec skip-header) (conj headers (first lines)) {})
               {:headers headers
                :grouped (->> lines
                              (map #(assoc {} :fname (str prefix (line-fn %) suffix)
                                           :line %))
                              (group-by :fname))}))]
       (doseq [fname (keys grouped)]
         (spit fname (string/join "\n"
                                  (concat headers
                                          (->> (get grouped fname)
                                               (map :line))))))))))

