(ns ltof.core
  (:require
   [clojure.java.io :as io]
   [clojure.string  :as string]))

(defn ltof
  "Split file f line by line into other files
   named by line-fn function."
  {:added "0.1.0"}
  ([f line-fn]
   (ltof f line-fn {}))
  ([f line-fn opts]
   (with-open [rdr (io/reader f)]
     (let [prefix (:prefix opts)
           suffix (:suffix opts)
           skip-header (if-let [s-h (:skip-header opts)]
                         s-h
                         0)
           grouped (->> (line-seq rdr)
                        (drop skip-header)
                        (map #(assoc {} :fname (str prefix (line-fn %) suffix)
                                     :line %))
                        (group-by :fname))]
       (doseq [fname (keys grouped)]
         (spit fname (->> (get grouped fname)
                          (map :line)
                          (string/join "\n"))))))))
