(defproject com.evanjbowling/ltof "0.1.0-rc2"
  :description "Split one file into many via Clojure line to file api."
  :url "https://github.com/evanjbowling/ltof"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"
            :comments "same as Clojure"}
  :dependencies [[org.clojure/clojure "1.8.0"]]
  :exclusions [[org.clojure/clojure]]
  :main nil
  :target-path "target/%s"
  :plugins [[lein-cljfmt "0.5.7"]
            [lein-pprint "1.2.0"]]
  :profiles {:uberjar {:aot :all}
             :dev     {:dependencies [[clojure-csv/clojure-csv "2.0.1"]]}}
  :scm {:name "git"
        :url "https://github.com/evanjbowling/ltof"}
  :deploy-branches ["master"]
  :deploy-repositories [["releases" :clojars]]
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "autotag-"]
                  ["deploy"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]])
