(ns ltof.core
  (:require
   [clojure.java.io :as io]
   [clojure.string  :as string]))

  ;; TODO: support opts  {:defaults {}, :name-fn {}}
(defn ltof
  "Split a file into many files based on line-fn."
  {:added "0.1.0"}
  ([f line-fn]
   (with-open [rdr (io/reader f)]
     (let [grouped (->> (line-seq rdr)
                        (map #(assoc {} :fname (line-fn %)
                                     :line %))
                        (group-by :fname))]
       (doseq [fname (keys grouped)]
         (spit fname (->> (get grouped fname)
                          (map :line)
                          (string/join "\n"))))))))
