/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpCookedConnection;
import com.ericsson.otp.erlang.OtpEpmd;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMbox;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNodeStatus;
import com.ericsson.otp.erlang.OtpPeer;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class OtpNode
extends OtpLocalNode {
    private boolean initDone = false;
    private Acceptor acceptor = null;
    Hashtable<String, OtpCookedConnection> connections = null;
    Mailboxes mboxes = null;
    OtpNodeStatus handler;
    private int flags = 0;

    public OtpNode(String string) throws IOException {
        this(string, defaultCookie, 0);
    }

    public OtpNode(String string, String string2) throws IOException {
        this(string, string2, 0);
    }

    public OtpNode(String string, String string2, int n) throws IOException {
        super(string, string2);
        this.init(n);
    }

    private synchronized void init(int n) throws IOException {
        if (!this.initDone) {
            this.connections = new Hashtable(17, 0.95f);
            this.mboxes = new Mailboxes();
            this.acceptor = new Acceptor(n);
            this.initDone = true;
        }
    }

    public synchronized void close() {
        this.acceptor.quit();
        Collection<OtpCookedConnection> collection = this.connections.values();
        Iterator<OtpCookedConnection> iterator = collection.iterator();
        this.mboxes.clear();
        while (iterator.hasNext()) {
            OtpCookedConnection otpCookedConnection = iterator.next();
            iterator.remove();
            otpCookedConnection.close();
        }
        this.initDone = false;
    }

    protected void finalize() {
        this.close();
    }

    public OtpMbox createMbox() {
        return this.mboxes.create();
    }

    public void closeMbox(OtpMbox otpMbox) {
        this.closeMbox(otpMbox, new OtpErlangAtom("normal"));
    }

    public void closeMbox(OtpMbox otpMbox, OtpErlangObject otpErlangObject) {
        if (otpMbox != null) {
            this.mboxes.remove(otpMbox);
            otpMbox.name = null;
            otpMbox.breakLinks(otpErlangObject);
        }
    }

    public OtpMbox createMbox(String string) {
        return this.mboxes.create(string);
    }

    public boolean registerName(String string, OtpMbox otpMbox) {
        return this.mboxes.register(string, otpMbox);
    }

    public String[] getNames() {
        return this.mboxes.names();
    }

    public OtpErlangPid whereis(String string) {
        OtpMbox otpMbox = this.mboxes.get(string);
        if (otpMbox != null) {
            return otpMbox.self();
        }
        return null;
    }

    public synchronized void registerStatusHandler(OtpNodeStatus otpNodeStatus) {
        this.handler = otpNodeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(String string, long l) {
        if (string.equals(this.node)) {
            return true;
        }
        if (string.indexOf(64, 0) < 0 && string.equals(this.node.substring(0, this.node.indexOf(64, 0)))) {
            return true;
        }
        OtpMbox otpMbox = null;
        try {
            otpMbox = this.createMbox();
            otpMbox.send("net_kernel", string, this.getPingTuple(otpMbox));
            OtpErlangObject otpErlangObject = otpMbox.receive(l);
            OtpErlangTuple otpErlangTuple = (OtpErlangTuple)otpErlangObject;
            OtpErlangAtom otpErlangAtom = (OtpErlangAtom)otpErlangTuple.elementAt(1);
            boolean bl = "yes".equals(otpErlangAtom.atomValue());
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.closeMbox(otpMbox);
        }
        return false;
    }

    private OtpErlangTuple getPingTuple(OtpMbox otpMbox) {
        OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[3];
        OtpErlangObject[] otpErlangObjectArray2 = new OtpErlangObject[2];
        OtpErlangObject[] otpErlangObjectArray3 = new OtpErlangObject[2];
        otpErlangObjectArray2[0] = otpMbox.self();
        otpErlangObjectArray2[1] = this.createRef();
        otpErlangObjectArray3[0] = new OtpErlangAtom("is_auth");
        otpErlangObjectArray3[1] = new OtpErlangAtom(this.node());
        otpErlangObjectArray[0] = new OtpErlangAtom("$gen_call");
        otpErlangObjectArray[1] = new OtpErlangTuple(otpErlangObjectArray2);
        otpErlangObjectArray[2] = new OtpErlangTuple(otpErlangObjectArray3);
        return new OtpErlangTuple(otpErlangObjectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean netKernel(OtpMsg otpMsg) {
        OtpMbox otpMbox = null;
        try {
            OtpErlangTuple otpErlangTuple = (OtpErlangTuple)otpMsg.getMsg();
            OtpErlangTuple otpErlangTuple2 = (OtpErlangTuple)otpErlangTuple.elementAt(1);
            OtpErlangPid otpErlangPid = (OtpErlangPid)otpErlangTuple2.elementAt(0);
            OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[]{otpErlangTuple2.elementAt(1), new OtpErlangAtom("yes")};
            otpMbox = this.createMbox();
            otpMbox.send(otpErlangPid, (OtpErlangObject)new OtpErlangTuple(otpErlangObjectArray));
            boolean bl = true;
            this.closeMbox(otpMbox);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            this.closeMbox(otpMbox);
        }
    }

    boolean deliver(OtpMsg otpMsg) {
        OtpMbox otpMbox = null;
        try {
            int n = otpMsg.type();
            if (n == 6) {
                String string = otpMsg.getRecipientName();
                if (string.equals("net_kernel")) {
                    return this.netKernel(otpMsg);
                }
                otpMbox = this.mboxes.get(string);
            } else {
                otpMbox = this.mboxes.get(otpMsg.getRecipientPid());
            }
            if (otpMbox == null) {
                return false;
            }
            otpMbox.deliver(otpMsg);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    void deliverError(OtpCookedConnection otpCookedConnection, Exception exception) {
        this.removeConnection(otpCookedConnection);
        this.remoteStatus(otpCookedConnection.name, false, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OtpCookedConnection getConnection(String string) {
        OtpPeer otpPeer = null;
        OtpCookedConnection otpCookedConnection = null;
        Hashtable<String, OtpCookedConnection> hashtable = this.connections;
        synchronized (hashtable) {
            otpCookedConnection = this.connections.get(string);
            if (otpCookedConnection == null && (otpCookedConnection = this.connections.get((otpPeer = new OtpPeer(string)).node())) == null) {
                try {
                    otpCookedConnection = new OtpCookedConnection(this, otpPeer);
                    otpCookedConnection.setFlags(this.flags);
                    this.addConnection(otpCookedConnection);
                }
                catch (Exception exception) {
                    this.connAttempt(otpPeer.node(), false, exception);
                }
            }
            return otpCookedConnection;
        }
    }

    void addConnection(OtpCookedConnection otpCookedConnection) {
        if (otpCookedConnection != null && otpCookedConnection.name != null) {
            this.connections.put(otpCookedConnection.name, otpCookedConnection);
            this.remoteStatus(otpCookedConnection.name, true, null);
        }
    }

    private void removeConnection(OtpCookedConnection otpCookedConnection) {
        if (otpCookedConnection != null && otpCookedConnection.name != null) {
            this.connections.remove(otpCookedConnection.name);
        }
    }

    private synchronized void remoteStatus(String string, boolean bl, Object object) {
        if (this.handler == null) {
            return;
        }
        try {
            this.handler.remoteStatus(string, bl, object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void localStatus(String string, boolean bl, Object object) {
        if (this.handler == null) {
            return;
        }
        try {
            this.handler.localStatus(string, bl, object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void connAttempt(String string, boolean bl, Object object) {
        if (this.handler == null) {
            return;
        }
        try {
            this.handler.connAttempt(string, bl, object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public class Acceptor
    extends Thread {
        private final ServerSocket sock;
        private final int port;
        private volatile boolean done = false;

        Acceptor(int n) throws IOException {
            this.sock = new ServerSocket(n);
            OtpNode.this.port = this.port = this.sock.getLocalPort();
            this.setDaemon(true);
            this.setName("acceptor");
            this.publishPort();
            this.start();
        }

        private boolean publishPort() throws IOException {
            if (OtpNode.this.getEpmd() != null) {
                return false;
            }
            OtpEpmd.publishPort(OtpNode.this);
            return true;
        }

        private void unPublishPort() {
            OtpEpmd.unPublishPort(OtpNode.this);
            this.closeSock(OtpNode.this.epmd);
            OtpNode.this.epmd = null;
        }

        public void quit() {
            this.unPublishPort();
            this.done = true;
            this.closeSock(this.sock);
            OtpNode.this.localStatus(OtpNode.this.node, false, null);
        }

        private void closeSock(ServerSocket serverSocket) {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void closeSock(Socket socket) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int port() {
            return this.port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket socket = null;
            OtpCookedConnection otpCookedConnection = null;
            OtpNode.this.localStatus(OtpNode.this.node, true, null);
            while (!this.done) {
                otpCookedConnection = null;
                try {
                    socket = this.sock.accept();
                }
                catch (Exception exception) {
                    if (this.done) break;
                    OtpNode.this.localStatus(OtpNode.this.node, false, exception);
                    break;
                }
                try {
                    Hashtable<String, OtpCookedConnection> hashtable = OtpNode.this.connections;
                    synchronized (hashtable) {
                        otpCookedConnection = new OtpCookedConnection(OtpNode.this, socket);
                        otpCookedConnection.setFlags(OtpNode.this.flags);
                        OtpNode.this.addConnection(otpCookedConnection);
                    }
                }
                catch (OtpAuthException otpAuthException) {
                    if (otpCookedConnection != null && otpCookedConnection.name != null) {
                        OtpNode.this.connAttempt(otpCookedConnection.name, true, otpAuthException);
                    } else {
                        OtpNode.this.connAttempt("unknown", true, otpAuthException);
                    }
                    this.closeSock(socket);
                }
                catch (IOException iOException) {
                    if (otpCookedConnection != null && otpCookedConnection.name != null) {
                        OtpNode.this.connAttempt(otpCookedConnection.name, true, iOException);
                    } else {
                        OtpNode.this.connAttempt("unknown", true, iOException);
                    }
                    this.closeSock(socket);
                }
                catch (Exception exception) {
                    this.closeSock(socket);
                    this.closeSock(this.sock);
                    OtpNode.this.localStatus(OtpNode.this.node, false, exception);
                    break;
                }
            }
            this.unPublishPort();
        }
    }

    public class Mailboxes {
        private Hashtable<OtpErlangPid, WeakReference<OtpMbox>> byPid = new Hashtable(17, 0.95f);
        private Hashtable<String, WeakReference<OtpMbox>> byName = new Hashtable(17, 0.95f);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OtpMbox create(String string) {
            OtpMbox otpMbox = null;
            Hashtable<String, WeakReference<OtpMbox>> hashtable = this.byName;
            synchronized (hashtable) {
                if (this.get(string) != null) {
                    return null;
                }
                OtpErlangPid otpErlangPid = OtpNode.this.createPid();
                otpMbox = new OtpMbox(OtpNode.this, otpErlangPid, string);
                this.byPid.put(otpErlangPid, new WeakReference<OtpMbox>(otpMbox));
                this.byName.put(string, new WeakReference<OtpMbox>(otpMbox));
            }
            return otpMbox;
        }

        public OtpMbox create() {
            OtpErlangPid otpErlangPid = OtpNode.this.createPid();
            OtpMbox otpMbox = new OtpMbox(OtpNode.this, otpErlangPid);
            this.byPid.put(otpErlangPid, new WeakReference<OtpMbox>(otpMbox));
            return otpMbox;
        }

        public void clear() {
            this.byPid.clear();
            this.byName.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] names() {
            String[] stringArray = null;
            Hashtable<String, WeakReference<OtpMbox>> hashtable = this.byName;
            synchronized (hashtable) {
                int n = this.byName.size();
                Enumeration<String> enumeration = this.byName.keys();
                stringArray = new String[n];
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    stringArray[n2++] = enumeration.nextElement();
                }
            }
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean register(String string, OtpMbox otpMbox) {
            if (string == null) {
                if (otpMbox.name != null) {
                    this.byName.remove(otpMbox.name);
                    otpMbox.name = null;
                }
            } else {
                Hashtable<String, WeakReference<OtpMbox>> hashtable = this.byName;
                synchronized (hashtable) {
                    if (this.get(string) != null) {
                        return false;
                    }
                    this.byName.put(string, new WeakReference<OtpMbox>(otpMbox));
                    otpMbox.name = string;
                }
            }
            return true;
        }

        public OtpMbox get(String string) {
            WeakReference<OtpMbox> weakReference = this.byName.get(string);
            if (weakReference != null) {
                OtpMbox otpMbox = (OtpMbox)weakReference.get();
                if (otpMbox != null) {
                    return otpMbox;
                }
                this.byName.remove(string);
            }
            return null;
        }

        public OtpMbox get(OtpErlangPid otpErlangPid) {
            WeakReference<OtpMbox> weakReference = this.byPid.get(otpErlangPid);
            if (weakReference != null) {
                OtpMbox otpMbox = (OtpMbox)weakReference.get();
                if (otpMbox != null) {
                    return otpMbox;
                }
                this.byPid.remove(otpErlangPid);
            }
            return null;
        }

        public void remove(OtpMbox otpMbox) {
            this.byPid.remove(otpMbox.self);
            if (otpMbox.name != null) {
                this.byName.remove(otpMbox.name);
            }
        }
    }
}

