/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpSelf;
import java.io.Serializable;

public class OtpErlangPort
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 4037115468007644704L;
    private final String node;
    private final int id;
    private final int creation;

    private OtpErlangPort(OtpSelf otpSelf) {
        OtpErlangPort otpErlangPort = otpSelf.createPort();
        this.id = otpErlangPort.id;
        this.creation = otpErlangPort.creation;
        this.node = otpErlangPort.node;
    }

    public OtpErlangPort(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        OtpErlangPort otpErlangPort = otpInputStream.read_port();
        this.node = otpErlangPort.node();
        this.id = otpErlangPort.id();
        this.creation = otpErlangPort.creation();
    }

    public OtpErlangPort(String string, int n, int n2) {
        this.node = string;
        this.id = n & 0xFFFFFFF;
        this.creation = n2 & 3;
    }

    public int id() {
        return this.id;
    }

    public int creation() {
        return this.creation;
    }

    public String node() {
        return this.node;
    }

    public String toString() {
        return "#Port<" + this.node + "." + this.id + ">";
    }

    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_port(this.node, this.id, this.creation);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangPort)) {
            return false;
        }
        OtpErlangPort otpErlangPort = (OtpErlangPort)object;
        return this.creation == otpErlangPort.creation && this.id == otpErlangPort.id && this.node.compareTo(otpErlangPort.node) == 0;
    }

    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(6);
        hash.combine(this.creation);
        hash.combine(this.id, this.node.hashCode());
        return hash.valueOf();
    }
}

