/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractConnection;
import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.Links;
import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNode;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import java.io.IOException;
import java.net.Socket;

public class OtpCookedConnection
extends AbstractConnection {
    protected OtpNode self;
    protected Links links = null;

    OtpCookedConnection(OtpNode otpNode, Socket socket) throws IOException, OtpAuthException {
        super((OtpLocalNode)otpNode, socket);
        this.self = otpNode;
        this.links = new Links(25);
        this.start();
    }

    OtpCookedConnection(OtpNode otpNode, OtpPeer otpPeer) throws IOException, OtpAuthException {
        super((OtpLocalNode)otpNode, otpPeer);
        this.self = otpNode;
        this.links = new Links(25);
        this.start();
    }

    public void deliver(Exception exception) {
        this.self.deliverError(this, exception);
    }

    public void deliver(OtpMsg otpMsg) {
        boolean bl = this.self.deliver(otpMsg);
        switch (otpMsg.type()) {
            case 1: {
                if (bl) {
                    this.links.addLink(otpMsg.getRecipientPid(), otpMsg.getSenderPid());
                    break;
                }
                try {
                    super.sendExit(otpMsg.getRecipientPid(), otpMsg.getSenderPid(), new OtpErlangAtom("noproc"));
                }
                catch (IOException iOException) {}
                break;
            }
            case 3: 
            case 4: {
                this.links.removeLink(otpMsg.getRecipientPid(), otpMsg.getSenderPid());
                break;
            }
        }
    }

    void send(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) throws IOException {
        this.sendBuf(otpErlangPid, otpErlangPid2, new OtpOutputStream(otpErlangObject));
    }

    void send(OtpErlangPid otpErlangPid, String string, OtpErlangObject otpErlangObject) throws IOException {
        this.sendBuf(otpErlangPid, string, new OtpOutputStream(otpErlangObject));
    }

    public void close() {
        super.close();
        this.breakLinks();
    }

    protected void finalize() {
        this.close();
    }

    void exit(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) {
        try {
            super.sendExit(otpErlangPid, otpErlangPid2, otpErlangObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void exit2(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) {
        try {
            super.sendExit2(otpErlangPid, otpErlangPid2, otpErlangObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void link(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) throws OtpErlangExit {
        try {
            super.sendLink(otpErlangPid, otpErlangPid2);
            this.links.addLink(otpErlangPid, otpErlangPid2);
        }
        catch (IOException iOException) {
            throw new OtpErlangExit("noproc", otpErlangPid2);
        }
    }

    synchronized void unlink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) {
        this.links.removeLink(otpErlangPid, otpErlangPid2);
        try {
            super.sendUnlink(otpErlangPid, otpErlangPid2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void breakLinks() {
        Link[] linkArray;
        if (this.links != null && (linkArray = this.links.clearLinks()) != null) {
            int n = linkArray.length;
            for (int i = 0; i < n; ++i) {
                this.self.deliver(new OtpMsg(3, linkArray[i].remote(), linkArray[i].local(), new OtpErlangAtom("noconnection")));
            }
        }
    }
}

