/*
 * Decompiled with CFR 0.152.
 */
package com.eldrix.hermes.client;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import com.eldrix.hermes.sct.IConcept;
import com.eldrix.hermes.sct.IDescription;
import com.eldrix.hermes.sct.IExtendedConcept;
import com.eldrix.hermes.sct.IResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Hermes {
    private final Object _hermes;
    private static final IFn openFn;
    private static final IFn closeFn;
    private static final IFn intoFn;
    private static final Object emptyMap;
    private static final IFn matchLocaleFn;
    private static final IFn searchFn;
    private static final IFn conceptFn;
    private static final IFn extendedConceptFn;
    private static final IFn preferredSynonymFn;
    private static final IFn subsumedByFn;
    private static final IFn parentRelationshipsOfTypeFn;
    private static final IFn childRelationshipsOfTypeFn;
    private static final IFn allChildrenFn;
    private static final IFn allParentsFn;
    private static final IFn lowerCaseTermFn;
    private static final IFn synonymsFn;
    private static final IFn areAnyFn;
    private static final IFn expandEcl;
    private static final IFn expandEclHistoric;
    private static final IFn expandEclPreferred;
    private static final IFn intersectEcl;
    private static final IFn isValidEcl;

    private static Keyword keyword(String string) {
        return Keyword.intern((String)string);
    }

    private Hermes(Object object) {
        if (object == null) {
            throw new NullPointerException("No Hermes service available");
        }
        this._hermes = object;
    }

    private Hermes(String string) {
        if (string == null) {
            throw new NullPointerException("Failed to open hermes: invalid path");
        }
        this._hermes = openFn.invoke((Object)string);
    }

    public static Hermes openLocal(String string) {
        return new Hermes(string);
    }

    public static Hermes open(Object object) {
        return new Hermes(object);
    }

    public void close() {
        closeFn.invoke(this._hermes);
    }

    public List<Long> matchLocale(String string) {
        return (List)matchLocaleFn.invoke(this._hermes, (Object)string);
    }

    public List<IResult> search(SearchRequest searchRequest) {
        List list = (List)searchFn.invoke(this._hermes, searchRequest._params);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public IConcept concept(long l) {
        return (IConcept)conceptFn.invoke(this._hermes, (Object)l);
    }

    public List<IConcept> concepts(List<Long> list) {
        return list.stream().map(this::concept).collect(Collectors.toList());
    }

    public IExtendedConcept extendedConcept(long l) {
        return (IExtendedConcept)extendedConceptFn.invoke(this._hermes, (Object)l);
    }

    public IDescription preferredSynonym(long l, String string) {
        return (IDescription)preferredSynonymFn.invoke(this._hermes, (Object)l, (Object)string);
    }

    public IDescription preferredSynonym(long l) {
        return this.preferredSynonym(l, Locale.getDefault().toLanguageTag());
    }

    public String preferredTerm(long l) {
        return this.preferredSynonym(l).term();
    }

    public String lowerCasePreferredTerm(long l) {
        return (String)lowerCaseTermFn.invoke((Object)this.preferredSynonym(l));
    }

    public List<String> synonyms(long l) {
        List list = (List)synonymsFn.invoke(this._hermes, (Object)l);
        return list.stream().map(iDescription -> iDescription.term()).collect(Collectors.toList());
    }

    public boolean isAConcept(IConcept iConcept, IConcept iConcept2) {
        return (Boolean)subsumedByFn.invoke(this._hermes, (Object)iConcept.id(), (Object)iConcept2.id());
    }

    public boolean subsumedBy(long l, long l2) {
        return (Boolean)subsumedByFn.invoke(this._hermes, (Object)l, (Object)l2);
    }

    public Collection<Long> childrenOfType(long l, long l2) {
        return (Collection)childRelationshipsOfTypeFn.invoke(this._hermes, (Object)l, (Object)l2);
    }

    public Collection<Long> parentsOfType(long l, long l2) {
        return (Collection)parentRelationshipsOfTypeFn.invoke(this._hermes, (Object)l, (Object)l2);
    }

    public Collection<Long> allParents(long l) {
        return (Collection)allParentsFn.invoke(this._hermes, (Object)l);
    }

    public Collection<Long> allChildren(long l) {
        return (Collection)allChildrenFn.invoke(this._hermes, (Object)l);
    }

    public Collection<Long> allChildren(long l, long l2) {
        return (Collection)allChildrenFn.invoke(this._hermes, (Object)l, (Object)l2);
    }

    public boolean areAny(List<Long> list, Collection<Long> collection) {
        return null != areAnyFn.invoke(this._hermes, list, collection);
    }

    public boolean isAny(Long l, Collection<Long> collection) {
        return this.areAny(Collections.singletonList(l), collection);
    }

    public List<IResult> expandEcl(String string, boolean bl) {
        if (bl) {
            return (List)expandEclHistoric.invoke(this._hermes, (Object)string);
        }
        return (List)expandEcl.invoke(this._hermes, (Object)string);
    }

    public List<IResult> expandEcl(String string, int n) {
        return (List)expandEcl.invoke(this._hermes, (Object)string, (Object)n);
    }

    public List<IResult> expandEclPreferred(String string, String string2) {
        List<Long> list = this.matchLocale(string2);
        return (List)expandEclPreferred.invoke(this._hermes, (Object)string, list);
    }

    public List<IResult> expandEclPreferred(String string, Long l) {
        return (List)expandEclPreferred.invoke(this._hermes, (Object)string, Collections.singletonList(l));
    }

    public List<IResult> expandEclPreferred(String string, Collection<Long> collection) {
        return (List)expandEclPreferred.invoke(this._hermes, (Object)string, collection);
    }

    public Set<Long> intersectEcl(Collection<Long> collection, String string) {
        return (Set)intersectEcl.invoke(this._hermes, collection, (Object)string);
    }

    public boolean isValidEcl(String string) {
        return (Boolean)isValidEcl.invoke((Object)string);
    }

    public static SearchRequestBuilder newSearchRequestBuilder() {
        return new SearchRequestBuilder();
    }

    static {
        IFn iFn = Clojure.var((Object)"clojure.core", (Object)"require");
        openFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"open");
        closeFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"close");
        intoFn = Clojure.var((Object)"clojure.core", (Object)"into");
        emptyMap = Clojure.read((String)"{}");
        iFn.invoke(Clojure.read((String)"com.eldrix.hermes.core"));
        matchLocaleFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"match-locale");
        searchFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"search");
        conceptFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"concept");
        extendedConceptFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"extended-concept");
        preferredSynonymFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"preferred-synonym");
        subsumedByFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"subsumed-by?");
        parentRelationshipsOfTypeFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"parent-relationships-of-type");
        childRelationshipsOfTypeFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"child-relationships-of-type");
        allChildrenFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"all-children");
        allParentsFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"all-parents");
        lowerCaseTermFn = Clojure.var((Object)"com.eldrix.hermes.snomed", (Object)"term->lowercase");
        synonymsFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"synonyms");
        areAnyFn = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"are-any?");
        expandEcl = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"expand-ecl");
        expandEclHistoric = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"expand-ecl-historic");
        expandEclPreferred = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"expand-ecl*");
        intersectEcl = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"intersect-ecl");
        isValidEcl = Clojure.var((Object)"com.eldrix.hermes.core", (Object)"valid-ecl?");
    }

    public static class SearchRequest {
        final Object _params;

        private SearchRequest(Map<Object, Object> map) {
            this._params = intoFn.invoke(emptyMap, map);
        }
    }

    public static final class SearchRequestBuilder {
        String _s;
        int _max_hits = -1;
        int _fuzzy = -1;
        int _fallback_fuzzy = -1;
        Boolean _show_fsn;
        String _constraint;
        Collection<Long> _is_a = null;
        Object _s_kw = Hermes.keyword("s");
        Object _max_hits_kw = Hermes.keyword("max-hits");
        Object _fuzzy_kw = Hermes.keyword("fuzzy");
        Object _fallback_fuzzy_kw = Hermes.keyword("fallback-fuzzy");
        Object _show_fsn_kw = Hermes.keyword("show-fsn");
        Object _constraint_kw = Hermes.keyword("constraint");
        Object _properties_kw = Hermes.keyword("properties");

        public SearchRequestBuilder setS(String string) {
            this._s = string;
            return this;
        }

        public SearchRequestBuilder setMaxHits(int n) {
            this._max_hits = n;
            return this;
        }

        public SearchRequestBuilder setFuzzy(int n) {
            this._fuzzy = n;
            return this;
        }

        public SearchRequestBuilder setFallbackFuzzy(int n) {
            this._fallback_fuzzy = n;
            return this;
        }

        public SearchRequestBuilder setShowFsn(boolean bl) {
            this._show_fsn = bl;
            return this;
        }

        public SearchRequestBuilder setConstraint(String string) {
            this._constraint = string;
            return this;
        }

        public SearchRequestBuilder setIsA(Collection<Long> collection) {
            this._is_a = collection;
            return this;
        }

        public SearchRequestBuilder setIsA(Long l) {
            this._is_a = Collections.singletonList(l);
            return this;
        }

        public SearchRequest build() {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            if (this._s != null) {
                hashMap.put(this._s_kw, this._s);
            }
            if (this._max_hits >= 0) {
                hashMap.put(this._max_hits_kw, this._max_hits);
            }
            if (this._fuzzy >= 0) {
                hashMap.put(this._fuzzy_kw, this._fuzzy);
            }
            if (this._fallback_fuzzy >= 0) {
                hashMap.put(this._fallback_fuzzy_kw, this._fallback_fuzzy);
            }
            if (this._show_fsn != null) {
                hashMap.put(this._show_fsn_kw, this._show_fsn);
            }
            if (this._constraint != null) {
                hashMap.put(this._constraint_kw, this._constraint);
            }
            if (this._is_a != null) {
                HashMap<Long, Collection<Long>> hashMap2 = new HashMap<Long, Collection<Long>>();
                hashMap2.put(116680003L, this._is_a);
                hashMap.put(this._properties_kw, hashMap2);
            }
            return new SearchRequest(hashMap);
        }
    }
}

