(ns com.eldrix.hermes.impl.compress
  (:import (net.jpountz.lz4 LZ4Factory LZ4Compressor LZ4FastDecompressor)
           (java.io ByteArrayOutputStream DataOutputStream ByteArrayInputStream DataInputStream)))


(def lz4-factory (delay (LZ4Factory/fastestInstance)))
(def compressor (delay (.highCompressor @lz4-factory)))
(def decompressor (delay (.fastDecompressor @lz4-factory)))

(defn compress
  [^bytes data]
  (let [^LZ4Compressor compressor @compressor
        uncompressed-length (alength data)
        max-compressed-length (.maxCompressedLength compressor uncompressed-length)
        data' (byte-array max-compressed-length)
        compressed-length (.compress compressor data 0 uncompressed-length data' 0 max-compressed-length)
        baos (ByteArrayOutputStream. (+ 4 compressed-length)) ;; space for length and the compressed data
        dos (DataOutputStream. baos)]
    (.writeInt dos uncompressed-length)
    (.write dos data' 0 compressed-length)
    (.toByteArray baos)))

(defn uncompress
  [^bytes data]
  (let [^LZ4FastDecompressor decompressor @decompressor
        bais (ByteArrayInputStream. data)
        dis (DataInputStream. bais)
        uncompressed-length (.readInt dis)
        data' (byte-array uncompressed-length)]
    (.decompress decompressor data 4 data' 0 uncompressed-length)
    data'))


