(ns com.eldrix.dmd.transform
  "Provides support for mapping between dose-based and product-based
  prescribing.

  Background information is available from the NHS BSA:
  https://www.nhsbsa.nhs.uk/sites/default/files/2017-02/Secondary_Care_Electronic_Prescribing_Implementation_Guidance_5_0.pdf

  Unfortunately, dm+d does *not* include Trade Family (TF) components, but that
  is contained within the UK SNOMED CT drug extension distribution. As a result,
  this library/service forms only a part of a wider prescribing implementation.
  It is expressly designed for this purpose."
  (:require [clojure.spec.alpha :as s]))


(def expected
  [:product {:medication 111
             :dosage {:timing {:code :org.hl7.fhir.TimingAbbreviation/BID}
                      :as-needed false}
             :site nil
             :method nil
             :route 222}])
