(ns com.eldrix.concierge.wales.core
  (:require [clojure.spec.alpha :as s]
            [com.eldrix.concierge.wales.cav-pms :as cav]
            [com.eldrix.concierge.registry :as reg]))

(s/def :org.hl7.fhir.Identifier/system string?)
(s/def :org.hl7.fhir.Identifier/value string?)
(s/def :org.hl7.fhir/Identifier (s/keys :req [:org.hl7.fhir.Identifier/system :org.hl7.fhir.Identifier/value]))
(s/def :org.hl7.fhir.Patient/identifiers (s/coll-of :org.hl7.fhir/Identifier :min-count 1))
(s/def :org.hl7.fhir/Patient (s/keys :req [:org.hl7.fhir.Patient/identifiers]))

(defn cav-resolve-patient
  "Resolve a patient using the system value pair in the context of
  Cardiff and Vale University Health Board.
  The authoritative source of patient identity is the underlying patient
  administrative system, 'PMS'. We could supplement that information with
  data from the national EMPI, but it has response times of >800ms.
  "
  [{:keys [system value] :as opts}]
  (cond
    (= system (:wales.nhs.cavuhb.id/pas-identifier reg/namespaces))
    (cav/fetch-patient-by-crn opts value)

    (= system (:uk.nhs.id/nhs-number reg/namespaces))
    (cav/fetch-patient-by-nnn opts value)))



(comment
  (s/valid? :org.hl7.fhir/Identifier {:org.hl7.fhir.Identifier/system "wibble"
                                      :org.hl7.fhir.Identifier/value "1111111111"})
  (s/valid? :org.hl7.fhir/Patient {:org.hl7.fhir.Patient/identifiers [{:org.hl7.fhir.Identifier/system "wibble"
                                                                       :org.hl7.fhir.Identifier/value "1111111111"}]})
  )