/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.util;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.event.WikiEngineEvent;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;

public abstract class WikiBackgroundThread
extends Thread
implements WikiEventListener {
    private volatile boolean m_killMe = false;
    private final WikiEngine m_engine;
    private final int m_interval;
    private static final long POLLING_INTERVAL = 1000L;

    public WikiBackgroundThread(WikiEngine engine, int sleepInterval) {
        this.m_engine = engine;
        this.m_interval = sleepInterval;
        engine.addWikiEventListener(this);
        this.setDaemon(false);
    }

    public final void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && ((WikiEngineEvent)event).getType() == 1) {
            System.out.println("Detected wiki engine shutdown: killing " + this.getName() + ".");
            this.m_killMe = true;
        }
    }

    public abstract void backgroundTask() throws Exception;

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public void shutdown() {
        this.m_killMe = true;
    }

    public final void run() {
        try {
            String name = this.getName();
            System.out.println("Starting up background thread: " + name + ".");
            this.startupTask();
            while (!this.m_killMe) {
                this.backgroundTask();
                boolean interrupted = false;
                try {
                    for (int i = 0; i < this.m_interval; ++i) {
                        Thread.sleep(1000L);
                        if (!this.m_killMe) continue;
                        interrupted = true;
                        System.out.println("Interrupted background thread: " + name + ".");
                        break;
                    }
                    if (!interrupted) continue;
                    break;
                }
                catch (Throwable t) {
                    System.err.println("Background thread error: (stack trace follows)");
                    t.printStackTrace();
                }
            }
            this.shutdownTask();
        }
        catch (Throwable t) {
            System.err.println("Background thread error: (stack trace follows)");
            t.printStackTrace();
            throw new InternalWikiException(t.getMessage());
        }
    }

    public void shutdownTask() throws Exception {
    }

    public void startupTask() throws Exception {
    }
}

