/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.search;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.SearchResult;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.search.SearchProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.ecyrd.jspwiki.util.WatchDog;
import com.ecyrd.jspwiki.util.WikiBackgroundThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneSearchProvider
implements SearchProvider {
    protected static final Logger log = Logger.getLogger(LuceneSearchProvider.class);
    private WikiEngine m_engine;
    public static final String PROP_LUCENE_ANALYZER = "jspwiki.lucene.analyzer";
    private static final String PROP_LUCENE_INDEXDELAY = "jspwiki.lucene.indexdelay";
    private static final String PROP_LUCENE_INITIALDELAY = "jspwiki.lucene.initialdelay";
    private String m_analyzerClass = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    private static final String LUCENE_DIR = "lucene";
    public static final int LUCENE_OPTIMIZE_COUNT = 10;
    protected static final String LUCENE_ID = "id";
    protected static final String LUCENE_PAGE_CONTENTS = "contents";
    protected static final String LUCENE_AUTHOR = "author";
    protected static final String LUCENE_ATTACHMENTS = "attachment";
    protected static final String LUCENE_PAGE_NAME = "name";
    private String m_luceneDirectory = null;
    private int m_updateCount = 0;
    protected Vector<Object[]> m_updates = new Vector();
    private static final int MAX_FRAGMENTS = 3;
    private static String c_punctuationSpaces = StringUtils.repeat((String)" ", (int)" ()&+,-=._$".length());
    public static final int FLAG_CONTEXTS = 1;

    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException, IOException {
        this.m_engine = engine;
        this.m_luceneDirectory = engine.getWorkDir() + File.separator + LUCENE_DIR;
        int initialDelay = TextUtil.getIntegerProperty(props, PROP_LUCENE_INITIALDELAY, 60);
        int indexDelay = TextUtil.getIntegerProperty(props, PROP_LUCENE_INDEXDELAY, 5);
        this.m_analyzerClass = TextUtil.getStringProperty(props, PROP_LUCENE_ANALYZER, this.m_analyzerClass);
        File dir = new File(this.m_luceneDirectory);
        log.info((Object)("Lucene enabled, cache will be in: " + dir.getAbsolutePath()));
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(dir.exists() && dir.canWrite() && dir.canRead())) {
                log.error((Object)("Cannot write to Lucene directory, disabling Lucene: " + dir.getAbsolutePath()));
                throw new IOException("Invalid Lucene directory.");
            }
            String[] filelist = dir.list();
            if (filelist == null) {
                throw new IOException("Invalid Lucene directory: cannot produce listing: " + dir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error((Object)"Problem while creating Lucene index - not using Lucene.", (Throwable)e);
        }
        LuceneUpdater updater = new LuceneUpdater(this.m_engine, this, initialDelay, indexDelay);
        updater.start();
    }

    protected WikiEngine getEngine() {
        return this.m_engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFullLuceneReindex() throws IOException {
        block24: {
            File dir = new File(this.m_luceneDirectory);
            String[] filelist = dir.list();
            if (filelist == null) {
                throw new IOException("Invalid Lucene directory: cannot produce listing: " + dir.getAbsolutePath());
            }
            try {
                if (filelist.length == 0) {
                    Date start = new Date();
                    IndexWriter writer = null;
                    log.info((Object)"Starting Lucene reindexing, this can take a couple minutes...");
                    FSDirectory luceneDir = FSDirectory.getDirectory((File)dir, (boolean)false);
                    if (IndexReader.isLocked((Directory)luceneDir)) {
                        log.info((Object)"JSPWiki was shut down while Lucene was indexing - unlocking now.");
                        IndexReader.unlock((Directory)luceneDir);
                    }
                    try {
                        writer = new IndexWriter(this.m_luceneDirectory, this.getLuceneAnalyzer(), true);
                        Collection allPages = this.m_engine.getPageManager().getAllPages();
                        for (WikiPage page : allPages) {
                            try {
                                String text = this.m_engine.getPageManager().getPageText(page.getName(), -1);
                                this.luceneIndexPage(page, text, writer);
                            }
                            catch (IOException e) {
                                log.warn((Object)("Unable to index page " + page.getName() + ", continuing to next "), (Throwable)e);
                            }
                        }
                        Collection allAttachments = this.m_engine.getAttachmentManager().getAllAttachments();
                        for (Attachment att : allAttachments) {
                            try {
                                String text = this.getAttachmentContent(att.getName(), -1);
                                this.luceneIndexPage(att, text, writer);
                            }
                            catch (IOException e) {
                                log.warn((Object)("Unable to index attachment " + att.getName() + ", continuing to next"), (Throwable)e);
                            }
                        }
                        writer.optimize();
                    }
                    finally {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException e) {}
                    }
                    Date end = new Date();
                    log.info((Object)("Full Lucene index finished in " + (end.getTime() - start.getTime()) + " milliseconds."));
                    break block24;
                }
                log.info((Object)"Files found in Lucene directory, not reindexing.");
            }
            catch (NoClassDefFoundError e) {
                log.info((Object)"Lucene libraries do not exist - not using Lucene.");
            }
            catch (IOException e) {
                log.error((Object)"Problem while creating Lucene index - not using Lucene.", (Throwable)e);
            }
            catch (ProviderException e) {
                log.error((Object)"Problem reading pages while creating Lucene index (JSPWiki won't start.)", (Throwable)e);
                throw new IllegalArgumentException("unable to create Lucene index");
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Illegal Analyzer specified:", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"Unable to start lucene", (Throwable)e);
            }
        }
    }

    protected String getAttachmentContent(String attachmentName, int version) {
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        try {
            Attachment att = mgr.getAttachmentInfo(attachmentName, version);
            if (att != null) {
                return this.getAttachmentContent(att);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"Attachment cannot be loaded", (Throwable)e);
        }
        return null;
    }

    protected String getAttachmentContent(Attachment att) {
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        String filename = att.getFileName();
        if (filename.endsWith(".txt") || filename.endsWith(".xml") || filename.endsWith(".ini") || filename.endsWith(".html")) {
            try {
                InputStream attStream = mgr.getAttachmentStream(att);
                StringWriter sout = new StringWriter();
                FileUtil.copyContents(new InputStreamReader(attStream), sout);
                attStream.close();
                sout.close();
                return sout.toString();
            }
            catch (ProviderException e) {
                log.error((Object)"Attachment cannot be loaded", (Throwable)e);
                return null;
            }
            catch (IOException e) {
                log.error((Object)"Attachment cannot be loaded", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateLuceneIndex(WikiPage page, String text) {
        IndexWriter writer = null;
        log.debug((Object)("Updating Lucene index for page '" + page.getName() + "'..."));
        try {
            this.pageRemoved(page);
            writer = new IndexWriter(this.m_luceneDirectory, this.getLuceneAnalyzer(), false);
            this.luceneIndexPage(page, text, writer);
            ++this.m_updateCount;
            if (this.m_updateCount >= 10) {
                writer.optimize();
                this.m_updateCount = 0;
            }
        }
        catch (IOException e) {
            log.error((Object)("Unable to update page '" + page.getName() + "' from Lucene index"), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Unexpected Lucene exception - please check configuration!", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
        log.debug((Object)("Done updating Lucene index for page '" + page.getName() + "'."));
    }

    private Analyzer getLuceneAnalyzer() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = ClassUtil.findClass("", this.m_analyzerClass);
        Analyzer analyzer = (Analyzer)clazz.newInstance();
        return analyzer;
    }

    protected Document luceneIndexPage(WikiPage page, String text, IndexWriter writer) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Indexing " + page.getName() + "..."));
        }
        Document doc = new Document();
        if (text == null) {
            return doc;
        }
        Field field = new Field(LUCENE_ID, page.getName(), Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add(field);
        field = new Field(LUCENE_PAGE_CONTENTS, text, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO);
        doc.add(field);
        String unTokenizedTitle = StringUtils.replaceChars((String)page.getName(), (String)" ()&+,-=._$", (String)c_punctuationSpaces);
        field = new Field(LUCENE_PAGE_NAME, TextUtil.beautifyString(page.getName()) + " " + unTokenizedTitle, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO);
        doc.add(field);
        if (page.getAuthor() != null) {
            field = new Field(LUCENE_AUTHOR, page.getAuthor(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO);
            doc.add(field);
        }
        try {
            Collection attachments = this.m_engine.getAttachmentManager().listAttachments(page);
            String attachmentNames = "";
            for (Attachment att : attachments) {
                attachmentNames = attachmentNames + att.getName() + ";";
            }
            field = new Field(LUCENE_ATTACHMENTS, attachmentNames, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO);
            doc.add(field);
        }
        catch (ProviderException e) {
            log.error((Object)"Failed to get attachments for page", (Throwable)e);
        }
        writer.addDocument(doc);
        return doc;
    }

    public void pageRemoved(WikiPage page) {
        try {
            IndexReader reader = IndexReader.open((String)this.m_luceneDirectory);
            reader.deleteDocuments(new Term(LUCENE_ID, page.getName()));
            reader.close();
        }
        catch (IOException e) {
            log.error((Object)("Unable to update page '" + page.getName() + "' from Lucene index"), (Throwable)e);
        }
    }

    public void reindexPage(WikiPage page) {
        String text;
        if (page != null && (text = page instanceof Attachment ? this.getAttachmentContent((Attachment)page) : this.m_engine.getPureText(page)) != null) {
            Object[] pair = new Object[]{page, text};
            this.m_updates.add(pair);
            log.debug((Object)("Scheduling page " + page.getName() + " for index update"));
        }
    }

    public Collection findPages(String query) throws ProviderException {
        return this.findPages(query, 1);
    }

    public Collection findPages(String query, int flags) throws ProviderException {
        IndexSearcher searcher = null;
        ArrayList<SearchResultImpl> list = null;
        Highlighter highlighter = null;
        try {
            String[] queryfields = new String[]{LUCENE_PAGE_CONTENTS, LUCENE_PAGE_NAME, LUCENE_AUTHOR, LUCENE_ATTACHMENTS};
            MultiFieldQueryParser qp = new MultiFieldQueryParser(queryfields, this.getLuceneAnalyzer());
            Query luceneQuery = qp.parse(query);
            if ((flags & 1) != 0) {
                highlighter = new Highlighter((Formatter)new SimpleHTMLFormatter("<span class=\"searchmatch\">", "</span>"), (Encoder)new SimpleHTMLEncoder(), (Scorer)new QueryScorer(luceneQuery));
            }
            try {
                searcher = new IndexSearcher(this.m_luceneDirectory);
            }
            catch (Exception ex) {
                log.info((Object)"Lucene not yet ready; indexing not started", (Throwable)ex);
                Collection collection = null;
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return collection;
            }
            Hits hits = searcher.search(luceneQuery);
            list = new ArrayList<SearchResultImpl>(hits.length());
            for (int curr = 0; curr < hits.length(); ++curr) {
                Document doc = hits.doc(curr);
                String pageName = doc.get(LUCENE_ID);
                WikiPage page = this.m_engine.getPage(pageName, -1);
                if (page != null) {
                    if (page instanceof Attachment) {
                        // empty if block
                    }
                    int score = (int)(hits.score(curr) * 100.0f);
                    String text = doc.get(LUCENE_PAGE_CONTENTS);
                    String[] fragments = new String[]{};
                    if (text != null && highlighter != null) {
                        TokenStream tokenStream = this.getLuceneAnalyzer().tokenStream(LUCENE_PAGE_CONTENTS, (Reader)new StringReader(text));
                        fragments = highlighter.getBestFragments(tokenStream, text, 3);
                    }
                    SearchResultImpl result = new SearchResultImpl(page, score, fragments);
                    list.add(result);
                    continue;
                }
                log.error((Object)("Lucene found a result page '" + pageName + "' that could not be loaded, removing from Lucene cache"));
                this.pageRemoved(new WikiPage(this.m_engine, pageName));
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed during lucene search", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Unable to get a Lucene analyzer", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Unable to get a Lucene analyzer", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Specified Lucene analyzer does not exist", (Throwable)e);
        }
        catch (ParseException e) {
            log.info((Object)"Broken query; cannot parse", (Throwable)e);
            throw new ProviderException("You have entered a query Lucene cannot process: " + e.getMessage());
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }

    public String getProviderInfo() {
        return "LuceneSearchProvider";
    }

    private static class SearchResultImpl
    implements SearchResult {
        private WikiPage m_page;
        private int m_score;
        private String[] m_contexts;

        public SearchResultImpl(WikiPage page, int score, String[] contexts) {
            this.m_page = page;
            this.m_score = score;
            this.m_contexts = contexts;
        }

        public WikiPage getPage() {
            return this.m_page;
        }

        public int getScore() {
            return this.m_score;
        }

        public String[] getContexts() {
            return this.m_contexts;
        }
    }

    private static final class LuceneUpdater
    extends WikiBackgroundThread {
        protected static final int INDEX_DELAY = 5;
        protected static final int INITIAL_DELAY = 60;
        private final LuceneSearchProvider m_provider;
        private int m_initialDelay;
        private WatchDog m_watchdog;

        private LuceneUpdater(WikiEngine engine, LuceneSearchProvider provider, int initialDelay, int indexDelay) {
            super(engine, indexDelay);
            this.m_provider = provider;
            this.setName("JSPWiki Lucene Indexer");
        }

        public void startupTask() throws Exception {
            this.m_watchdog = this.getEngine().getCurrentWatchDog();
            try {
                Thread.sleep((long)this.m_initialDelay * 1000L);
            }
            catch (InterruptedException e) {
                throw new InternalWikiException("Interrupted while waiting to start.");
            }
            this.m_watchdog.enterState("Full reindex");
            this.m_provider.doFullLuceneReindex();
            this.m_watchdog.exitState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void backgroundTask() throws Exception {
            this.m_watchdog.enterState("Emptying index queue", 60);
            Vector<Object[]> vector = this.m_provider.m_updates;
            synchronized (vector) {
                while (this.m_provider.m_updates.size() > 0) {
                    Object[] pair = this.m_provider.m_updates.remove(0);
                    WikiPage page = (WikiPage)pair[0];
                    String text = (String)pair[1];
                    this.m_provider.updateLuceneIndex(page, text);
                }
            }
            this.m_watchdog.exitState();
        }
    }
}

