/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.AbstractFileProvider;
import com.ecyrd.jspwiki.providers.NoSuchVersionException;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class RCSFileProvider
extends AbstractFileProvider {
    private String m_checkinCommand = "ci -m\"author=%u;changenote=%c\" -l -t-none %s";
    private String m_checkoutCommand = "co -l %s";
    private String m_logCommand = "rlog -zLT -r %s";
    private String m_fullLogCommand = "rlog -zLT %s";
    private String m_checkoutVersionCommand = "co -p -r1.%v %s";
    private String m_deleteVersionCommand = "rcs -o1.%v %s";
    private static final Logger log = Logger.getLogger(RCSFileProvider.class);
    public static final String PROP_CHECKIN = "jspwiki.rcsFileProvider.checkinCommand";
    public static final String PROP_CHECKOUT = "jspwiki.rcsFileProvider.checkoutCommand";
    public static final String PROP_LOG = "jspwiki.rcsFileProvider.logCommand";
    public static final String PROP_FULLLOG = "jspwiki.rcsFileProvider.fullLogCommand";
    public static final String PROP_CHECKOUTVERSION = "jspwiki.rcsFileProvider.checkoutVersionCommand";
    private static final String PATTERN_DATE = "^date:\\s*(.*\\d);";
    private static final String PATTERN_AUTHOR = "^\"?author=([\\w\\.\\s\\+\\.\\%]*)\"?";
    private static final String PATTERN_CHANGENOTE = ";changenote=([\\w\\.\\s\\+\\.\\%]*)\"?";
    private static final String PATTERN_REVISION = "^revision \\d+\\.(\\d+)";
    private static final String RCSFMT_DATE = "yyyy-MM-dd HH:mm:ss";
    private static final String RCSFMT_DATE_UTC = "yyyy/MM/dd HH:mm:ss";
    private SimpleDateFormat m_rcsdatefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat m_rcsdatefmtUTC = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException, IOException {
        log.debug((Object)"Initing RCS");
        super.initialize(engine, props);
        this.m_checkinCommand = props.getProperty(PROP_CHECKIN, this.m_checkinCommand);
        this.m_checkoutCommand = props.getProperty(PROP_CHECKOUT, this.m_checkoutCommand);
        this.m_logCommand = props.getProperty(PROP_LOG, this.m_logCommand);
        this.m_fullLogCommand = props.getProperty(PROP_FULLLOG, this.m_fullLogCommand);
        this.m_checkoutVersionCommand = props.getProperty(PROP_CHECKOUTVERSION, this.m_checkoutVersionCommand);
        File rcsdir = new File(this.getPageDirectory(), "RCS");
        if (!rcsdir.exists()) {
            rcsdir.mkdirs();
        }
        log.debug((Object)("checkin=" + this.m_checkinCommand));
        log.debug((Object)("checkout=" + this.m_checkoutCommand));
        log.debug((Object)("log=" + this.m_logCommand));
        log.debug((Object)("fulllog=" + this.m_fullLogCommand));
        log.debug((Object)("checkoutversion=" + this.m_checkoutVersionCommand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        BufferedReader stdout = null;
        WikiPage info = super.getPageInfo(page, version);
        if (info == null) {
            return null;
        }
        try {
            String line;
            String cmd = this.m_fullLogCommand;
            cmd = TextUtil.replaceString(cmd, "%s", this.mangleName(page) + ".txt");
            Process process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
            stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Pattern headpattern = compiler.compile(PATTERN_REVISION);
            Pattern userpattern = compiler.compile(PATTERN_AUTHOR);
            Pattern datepattern = compiler.compile(PATTERN_DATE);
            Pattern notepattern = compiler.compile(PATTERN_CHANGENOTE);
            boolean found = false;
            while ((line = stdout.readLine()) != null) {
                MatchResult result;
                if (matcher.contains(line, headpattern)) {
                    result = matcher.getMatch();
                    try {
                        int vernum = Integer.parseInt(result.group(1));
                        if (vernum == version || version == -1) {
                            info.setVersion(vernum);
                            found = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        log.info((Object)"Failed to parse version number from RCS log: ", (Throwable)e);
                    }
                } else if (matcher.contains(line, datepattern) && found) {
                    result = matcher.getMatch();
                    Date d = this.parseDate(result.group(1));
                    if (d != null) {
                        info.setLastModified(d);
                    } else {
                        log.info((Object)("WikiPage " + info.getName() + " has null modification date for version " + version));
                    }
                } else if (found && line.startsWith("----")) break;
                if (found && matcher.contains(line, userpattern)) {
                    result = matcher.getMatch();
                    info.setAuthor(TextUtil.urlDecodeUTF8(result.group(1)));
                }
                if (!found || !matcher.contains(line, notepattern)) continue;
                result = matcher.getMatch();
                info.setAttribute("changenote", TextUtil.urlDecodeUTF8(result.group(1)));
            }
            while ((line = stdout.readLine()) != null) {
            }
            process.waitFor();
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to read RCS info", (Throwable)e);
        }
        finally {
            try {
                if (stdout != null) {
                    stdout.close();
                }
            }
            catch (IOException e) {}
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPageText(String page, int version) throws ProviderException {
        String result = null;
        InputStream stdout = null;
        BufferedReader stderr = null;
        Process process = null;
        if (version == -1) {
            return super.getPageText(page, version);
        }
        log.debug((Object)("Fetching specific version " + version + " of page " + page));
        try {
            String line;
            Perl5Matcher matcher = new Perl5Matcher();
            Perl5Compiler compiler = new Perl5Compiler();
            int checkedOutVersion = -1;
            String cmd = this.m_checkoutVersionCommand;
            cmd = TextUtil.replaceString(cmd, "%s", this.mangleName(page) + ".txt");
            cmd = TextUtil.replaceString(cmd, "%v", Integer.toString(version));
            log.debug((Object)("Command = '" + cmd + "'"));
            process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
            stdout = process.getInputStream();
            result = FileUtil.readContents(stdout, this.m_encoding);
            stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            Pattern headpattern = compiler.compile(PATTERN_REVISION);
            while ((line = stderr.readLine()) != null) {
                if (!matcher.contains(line, headpattern)) continue;
                MatchResult mr = matcher.getMatch();
                checkedOutVersion = Integer.parseInt(mr.group(1));
            }
            process.waitFor();
            int exitVal = process.exitValue();
            log.debug((Object)("Done, returned = " + exitVal));
            if (exitVal != 0 || checkedOutVersion == -1) {
                if (version != 1) throw new NoSuchVersionException("Page: " + page + ", version=" + version);
                result = super.getPageText(page, -1);
                return result;
            } else {
                if (checkedOutVersion == version) return result;
                throw new NoSuchVersionException("Page: " + page + ", version=" + version);
            }
        }
        catch (MalformedPatternException e) {
            throw new InternalWikiException("Malformed pattern in RCSFileProvider!");
        }
        catch (InterruptedException e) {
            log.info((Object)"RCS process was interrupted, we'll just return whatever we found.");
            return result;
        }
        catch (IOException e) {
            log.error((Object)"RCS checkout failed", (Throwable)e);
            return result;
        }
        finally {
            try {
                if (stdout != null) {
                    stdout.close();
                }
                if (stderr != null) {
                    stderr.close();
                }
                if (process != null) {
                    process.getInputStream().close();
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to close streams!");
            }
        }
    }

    public void putPageText(WikiPage page, String text) throws ProviderException {
        Process process = null;
        String pagename = page.getName();
        super.putPageText(page, text);
        log.debug((Object)"Checking in text...");
        try {
            String changenote;
            String cmd = this.m_checkinCommand;
            String author = page.getAuthor();
            if (author == null) {
                author = "unknown";
            }
            if ((changenote = (String)page.getAttribute("changenote")) == null) {
                changenote = "";
            }
            cmd = TextUtil.replaceString(cmd, "%s", this.mangleName(pagename) + ".txt");
            cmd = TextUtil.replaceString(cmd, "%u", TextUtil.urlEncodeUTF8(author));
            cmd = TextUtil.replaceString(cmd, "%c", TextUtil.urlEncodeUTF8(changenote));
            log.debug((Object)("Command = '" + cmd + "'"));
            process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
            process.waitFor();
            BufferedReader error = null;
            String elines = "";
            error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String line = null;
            while ((line = error.readLine()) != null) {
                elines = elines + line + "\n";
            }
            log.debug((Object)("Done, returned = " + process.exitValue()));
            log.debug((Object)elines);
            if (process.exitValue() != 0) {
                throw new ProviderException(cmd + "\n" + "Done, returned = " + process.exitValue() + "\n" + elines);
            }
        }
        catch (Exception e) {
            log.error((Object)"RCS checkin failed", (Throwable)e);
            ProviderException pe = new ProviderException("RCS checkin failed");
            pe.initCause(e);
            throw pe;
        }
        finally {
            if (process != null) {
                try {
                    if (process.getOutputStream() != null) {
                        process.getOutputStream().close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (process.getInputStream() != null) {
                        process.getInputStream().close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (process.getErrorStream() != null) {
                        process.getErrorStream().close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getVersionHistory(String page) {
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        BufferedReader stdout = null;
        log.debug((Object)"Getting RCS version history");
        ArrayList<WikiPage> list = new ArrayList<WikiPage>();
        try {
            String line;
            Pattern revpattern = compiler.compile(PATTERN_REVISION);
            Pattern datepattern = compiler.compile(PATTERN_DATE);
            Pattern userpattern = compiler.compile(PATTERN_AUTHOR);
            Pattern notepattern = compiler.compile(PATTERN_CHANGENOTE);
            String cmd = TextUtil.replaceString(this.m_fullLogCommand, "%s", this.mangleName(page) + ".txt");
            Process process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
            stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            WikiPage info = null;
            while ((line = stdout.readLine()) != null) {
                MatchResult result;
                if (matcher.contains(line, revpattern)) {
                    info = new WikiPage(this.m_engine, page);
                    result = matcher.getMatch();
                    int vernum = Integer.parseInt(result.group(1));
                    info.setVersion(vernum);
                    list.add(info);
                }
                if (matcher.contains(line, datepattern) && info != null) {
                    result = matcher.getMatch();
                    Date d = this.parseDate(result.group(1));
                    info.setLastModified(d);
                }
                if (matcher.contains(line, userpattern) && info != null) {
                    result = matcher.getMatch();
                    info.setAuthor(TextUtil.urlDecodeUTF8(result.group(1)));
                }
                if (!matcher.contains(line, notepattern) || info == null) continue;
                result = matcher.getMatch();
                info.setAttribute("changenote", TextUtil.urlDecodeUTF8(result.group(1)));
            }
            process.waitFor();
            process.getInputStream().close();
            process.getOutputStream().close();
            process.getErrorStream().close();
            for (WikiPage p : list) {
                String content = this.getPageText(p.getName(), p.getVersion());
                p.setSize(content.length());
            }
        }
        catch (Exception e) {
            log.error((Object)"RCS log failed", (Throwable)e);
        }
        finally {
            try {
                if (stdout != null) {
                    stdout.close();
                }
            }
            catch (IOException e) {}
        }
        return list;
    }

    public void deletePage(String page) throws ProviderException {
        log.debug((Object)("Deleting page " + page));
        super.deletePage(page);
        File rcsdir = new File(this.getPageDirectory(), "RCS");
        if (rcsdir.exists() && rcsdir.isDirectory()) {
            File rcsfile = new File(rcsdir, this.mangleName(page) + ".txt" + ",v");
            if (rcsfile.exists()) {
                if (!rcsfile.delete()) {
                    log.warn((Object)("Deletion of RCS file " + rcsfile.getAbsolutePath() + " failed!"));
                }
            } else {
                log.info((Object)("RCS file does not exist for page: " + page));
            }
        } else {
            log.info((Object)("No RCS directory at " + rcsdir.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(String page, int version) {
        String line = "<rcs not run>";
        BufferedReader stderr = null;
        boolean success = false;
        String cmd = this.m_deleteVersionCommand;
        log.debug((Object)("Deleting version " + version + " of page " + page));
        cmd = TextUtil.replaceString(cmd, "%s", this.mangleName(page) + ".txt");
        cmd = TextUtil.replaceString(cmd, "%v", Integer.toString(version));
        log.debug((Object)("Running command " + cmd));
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
            stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = stderr.readLine()) != null) {
                log.debug((Object)("LINE=" + line));
                if (!line.equals("done")) continue;
                success = true;
            }
        }
        catch (IOException e) {
            log.error((Object)"Page deletion failed: ", (Throwable)e);
        }
        finally {
            try {
                if (stderr != null) {
                    stderr.close();
                }
                if (process != null) {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Cannot close streams for process while deleting page version.");
            }
        }
        if (!success) {
            log.error((Object)("Version deletion failed. Last info from RCS is: " + line));
        }
    }

    private synchronized Date parseDate(String str) {
        Date d = null;
        try {
            d = this.m_rcsdatefmt.parse(str);
            return d;
        }
        catch (ParseException pe) {
            try {
                d = this.m_rcsdatefmtUTC.parse(str);
                return d;
            }
            catch (ParseException parseException) {
                return d;
            }
        }
    }

    public void movePage(String from, String to) throws ProviderException {
        File fromFile = this.findPage(from);
        File toFile = this.findPage(to);
        fromFile.renameTo(toFile);
        String fromRCSName = "RCS/" + this.mangleName(from) + ".txt" + ",v";
        String toRCSName = "RCS/" + this.mangleName(to) + ".txt" + ",v";
        File fromRCSFile = new File(this.getPageDirectory(), fromRCSName);
        File toRCSFile = new File(this.getPageDirectory(), toRCSName);
        fromRCSFile.renameTo(toRCSFile);
    }
}

