/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.filters;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiPageEvent;
import com.ecyrd.jspwiki.filters.FilterException;
import com.ecyrd.jspwiki.filters.PageFilter;
import com.ecyrd.jspwiki.modules.ModuleManager;
import com.ecyrd.jspwiki.modules.WikiModuleInfo;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.ecyrd.jspwiki.util.PriorityList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public final class FilterManager
extends ModuleManager {
    private PriorityList m_pageFilters = new PriorityList();
    private HashMap<String, PageFilterInfo> m_filterClassMap = new HashMap();
    private static final Logger log = Logger.getLogger(WikiEngine.class);
    public static final String PROP_FILTERXML = "jspwiki.filterConfig";
    public static final String DEFAULT_XMLFILE = "/WEB-INF/filters.xml";
    public static final int SYSTEM_FILTER_PRIORITY = -1000;
    public static final int USER_FILTER_PRIORITY = 0;

    public FilterManager(WikiEngine engine, Properties props) throws WikiException {
        super(engine);
        this.initialize(props);
    }

    public void addPageFilter(PageFilter f, int priority) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("Attempt to provide a null filter - this should never happen.  Please check your configuration (or if you're a developer, check your own code.)");
        }
        this.m_pageFilters.add(f, priority);
    }

    private void initPageFilter(String className, Properties props) {
        try {
            PageFilterInfo info = this.m_filterClassMap.get(className);
            if (info != null && !this.checkCompatibility(info)) {
                String msg = "Filter '" + info.getName() + "' not compatible with this version of JSPWiki";
                log.warn((Object)msg);
                return;
            }
            int priority = 0;
            Class cl = ClassUtil.findClass("com.ecyrd.jspwiki.filters", className);
            PageFilter filter = (PageFilter)cl.newInstance();
            filter.initialize(this.m_engine, props);
            this.addPageFilter(filter, priority);
            log.info((Object)("Added page filter " + cl.getName() + " with priority " + priority));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to find the filter class: " + className));
        }
        catch (InstantiationException e) {
            log.error((Object)("Cannot create filter class: " + className));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("You are not allowed to access class: " + className));
        }
        catch (ClassCastException e) {
            log.error((Object)("Suggested class is not a PageFilter: " + className));
        }
        catch (FilterException e) {
            log.error((Object)("Filter " + className + " failed to initialize itself."), (Throwable)e);
        }
    }

    protected void initialize(Properties props) throws WikiException {
        InputStream xmlStream = null;
        String xmlFile = props.getProperty(PROP_FILTERXML);
        try {
            this.registerFilters();
            if (this.m_engine.getServletContext() != null) {
                log.debug((Object)"Attempting to locate /WEB-INF/filters.xml from servlet context.");
                xmlStream = xmlFile == null ? this.m_engine.getServletContext().getResourceAsStream(DEFAULT_XMLFILE) : this.m_engine.getServletContext().getResourceAsStream(xmlFile);
            }
            if (xmlStream == null) {
                log.debug((Object)"Attempting to locate filters.xml from class path.");
                xmlStream = xmlFile == null ? this.getClass().getResourceAsStream("/filters.xml") : this.getClass().getResourceAsStream(xmlFile);
            }
            if (xmlStream == null && xmlFile != null) {
                log.debug((Object)("Attempting to load property file " + xmlFile));
                xmlStream = new FileInputStream(new File(xmlFile));
            }
            if (xmlStream == null) {
                log.info((Object)("Cannot find property file for filters (this is okay, expected to find it as: '" + (xmlFile == null ? DEFAULT_XMLFILE : xmlFile) + "')"));
                return;
            }
            this.parseConfigFile(xmlStream);
        }
        catch (IOException e) {
            log.error((Object)"Unable to read property file", (Throwable)e);
        }
        catch (JDOMException e) {
            log.error((Object)"Problem in the XML file", (Throwable)e);
        }
    }

    private void parseConfigFile(InputStream xmlStream) throws JDOMException, IOException {
        Document doc = new SAXBuilder().build(xmlStream);
        XPath xpath = XPath.newInstance((String)"/pagefilters/filter");
        List nodes = xpath.selectNodes((Object)doc);
        for (Element f : nodes) {
            String filterClass = f.getChildText("class");
            Properties props = new Properties();
            List params = f.getChildren("param");
            for (Element p : params) {
                props.setProperty(p.getChildText("name"), p.getChildText("value"));
            }
            this.initPageFilter(filterClass, props);
        }
    }

    public String doPreTranslateFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(12, context);
        for (PageFilter f : this.m_pageFilters) {
            pageData = f.preTranslate(context, pageData);
        }
        this.fireEvent(14, context);
        return pageData;
    }

    public String doPostTranslateFiltering(WikiContext context, String htmlData) throws FilterException {
        this.fireEvent(15, context);
        for (PageFilter f : this.m_pageFilters) {
            htmlData = f.postTranslate(context, htmlData);
        }
        this.fireEvent(17, context);
        return htmlData;
    }

    public String doPreSaveFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(18, context);
        for (PageFilter f : this.m_pageFilters) {
            pageData = f.preSave(context, pageData);
        }
        this.fireEvent(20, context);
        return pageData;
    }

    public void doPostSaveFiltering(WikiContext context, String pageData) throws FilterException {
        this.fireEvent(21, context);
        for (PageFilter f : this.m_pageFilters) {
            f.postSave(context, pageData);
        }
        this.fireEvent(23, context);
    }

    public List getFilterList() {
        return this.m_pageFilters;
    }

    public void destroy() {
        for (PageFilter f : this.m_pageFilters) {
            f.destroy(this.m_engine);
        }
    }

    public final void fireEvent(int type, WikiContext context) {
        if (WikiEventManager.isListening(this) && WikiPageEvent.isValidType(type)) {
            WikiEventManager.fireEvent(this, new WikiPageEvent(this.m_engine, type, context.getPage().getName()));
        }
    }

    public Collection modules() {
        ArrayList modules = new ArrayList();
        modules.addAll(this.m_pageFilters);
        return modules;
    }

    private void registerFilters() {
        log.info((Object)"Registering filters");
        SAXBuilder builder = new SAXBuilder();
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("ini/jspwiki_module.xml");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                try {
                    log.debug((Object)("Processing XML: " + resource));
                    Document doc = builder.build(resource);
                    List plugins = XPath.selectNodes((Object)doc, (String)"/modules/filter");
                    for (Element pluginEl : plugins) {
                        String className = pluginEl.getAttributeValue("class");
                        PageFilterInfo pluginInfo = PageFilterInfo.newInstance(className, pluginEl);
                        if (pluginInfo == null) continue;
                        this.registerPlugin(pluginInfo);
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Couldn't load ini/jspwiki_module.xml resources: " + resource), (Throwable)e);
                }
                catch (JDOMException e) {
                    log.error((Object)"Error parsing XML for filter: ini/jspwiki_module.xml");
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Couldn't load all ini/jspwiki_module.xml resources", (Throwable)e);
        }
    }

    private void registerPlugin(PageFilterInfo pluginInfo) {
        this.m_filterClassMap.put(pluginInfo.getName(), pluginInfo);
    }

    private static final class PageFilterInfo
    extends WikiModuleInfo {
        private PageFilterInfo(String name) {
            super(name);
        }

        protected static PageFilterInfo newInstance(String className, Element pluginEl) {
            if (className == null || className.length() == 0) {
                return null;
            }
            PageFilterInfo info = new PageFilterInfo(className);
            info.initializeFromXML(pluginEl);
            return info;
        }
    }
}

