/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.login;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.auth.login.HttpRequestCallback;
import com.ecyrd.jspwiki.auth.login.UserDatabaseCallback;
import com.ecyrd.jspwiki.auth.login.WikiEngineCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;

public class WikiCallbackHandler
implements CallbackHandler {
    private final HttpServletRequest m_request;
    private final WikiEngine m_engine;
    private final String m_password;
    private final String m_username;

    public WikiCallbackHandler(WikiEngine engine, HttpServletRequest request, String username, String password) {
        this.m_request = request;
        this.m_engine = engine;
        this.m_username = username;
        this.m_password = password;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (callback instanceof HttpRequestCallback) {
                ((HttpRequestCallback)callback).setRequest(this.m_request);
                continue;
            }
            if (callback instanceof WikiEngineCallback) {
                ((WikiEngineCallback)callback).setEngine(this.m_engine);
                continue;
            }
            if (callback instanceof UserDatabaseCallback) {
                ((UserDatabaseCallback)callback).setUserDatabase(this.m_engine.getUserManager().getUserDatabase());
                continue;
            }
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.m_username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.m_password.toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

