/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.AuthorizationManager;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.UserManager;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.permissions.AllPermission;
import com.ecyrd.jspwiki.auth.user.UserDatabase;
import com.ecyrd.jspwiki.preferences.Preferences;
import com.ecyrd.jspwiki.ui.Command;
import com.ecyrd.jspwiki.ui.CommandResolver;
import com.ecyrd.jspwiki.ui.GroupCommand;
import com.ecyrd.jspwiki.ui.PageCommand;
import com.ecyrd.jspwiki.ui.WikiCommand;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;

public class WikiContext
implements Cloneable,
Command {
    private Command m_command = null;
    private WikiPage m_page;
    private WikiPage m_realPage;
    private WikiEngine m_engine;
    private String m_template = "default";
    private HashMap<String, Object> m_variableMap = new HashMap();
    protected HttpServletRequest m_request = null;
    private WikiSession m_session = null;
    public static final String INSTALL = WikiCommand.INSTALL.getRequestContext();
    public static final String VIEW = PageCommand.VIEW.getRequestContext();
    public static final String WORKFLOW = WikiCommand.WORKFLOW.getRequestContext();
    public static final String EDIT = PageCommand.EDIT.getRequestContext();
    public static final String LOGIN = WikiCommand.LOGIN.getRequestContext();
    public static final String LOGOUT = WikiCommand.LOGOUT.getRequestContext();
    public static final String MESSAGE = WikiCommand.MESSAGE.getRequestContext();
    public static final String DIFF = PageCommand.DIFF.getRequestContext();
    public static final String INFO = PageCommand.INFO.getRequestContext();
    public static final String PREVIEW = PageCommand.PREVIEW.getRequestContext();
    public static final String CONFLICT = PageCommand.CONFLICT.getRequestContext();
    public static final String ERROR = WikiCommand.ERROR.getRequestContext();
    public static final String UPLOAD = PageCommand.UPLOAD.getRequestContext();
    public static final String COMMENT = PageCommand.COMMENT.getRequestContext();
    public static final String FIND = WikiCommand.FIND.getRequestContext();
    public static final String CREATE_GROUP = WikiCommand.CREATE_GROUP.getRequestContext();
    public static final String DELETE_GROUP = GroupCommand.DELETE_GROUP.getRequestContext();
    public static final String EDIT_GROUP = GroupCommand.EDIT_GROUP.getRequestContext();
    public static final String VIEW_GROUP = GroupCommand.VIEW_GROUP.getRequestContext();
    public static final String PREFS = WikiCommand.PREFS.getRequestContext();
    public static final String RENAME = PageCommand.RENAME.getRequestContext();
    public static final String DELETE = PageCommand.DELETE.getRequestContext();
    public static final String ATTACH = PageCommand.ATTACH.getRequestContext();
    public static final String RSS = PageCommand.RSS.getRequestContext();
    public static final String NONE = PageCommand.NONE.getRequestContext();
    public static final String OTHER = PageCommand.OTHER.getRequestContext();
    public static final String ADMIN = WikiCommand.ADMIN.getRequestContext();
    private static final Logger log = Logger.getLogger(WikiContext.class);
    private static final Permission DUMMY_PERMISSION = new PropertyPermission("os.name", "read");

    public WikiContext(WikiEngine engine, WikiPage page) {
        this(engine, null, WikiContext.findCommand(engine, null, page));
    }

    public WikiContext(WikiEngine engine, HttpServletRequest request, Command command) throws IllegalArgumentException {
        if (engine == null || command == null) {
            throw new IllegalArgumentException("Parameter engine and command must not be null.");
        }
        this.m_engine = engine;
        this.m_request = request;
        this.m_session = WikiSession.getWikiSession(engine, request);
        this.m_command = command;
        if (command instanceof PageCommand) {
            this.m_page = (WikiPage)((PageCommand)command).getTarget();
        }
        if (this.m_page == null) {
            this.m_page = this.m_engine.getPage(this.m_engine.getFrontPage());
            if (this.m_page == null) {
                this.m_page = new WikiPage(this.m_engine, this.m_engine.getFrontPage());
            }
        }
        this.m_realPage = this.m_page;
        if (PageCommand.VIEW.equals(command) && command.getTarget() == null) {
            this.m_command = command.targetedCommand(this.m_page);
        }
        if (log.isDebugEnabled()) {
            HttpSession session = request == null ? null : request.getSession(false);
            String sid = session == null ? "(null)" : session.getId();
            log.debug((Object)("Creating WikiContext for session ID=" + sid + "; target=" + this.getName()));
        }
        this.setDefaultTemplate(request);
    }

    public WikiContext(WikiEngine engine, HttpServletRequest request, WikiPage page) {
        this(engine, request, WikiContext.findCommand(engine, request, page));
    }

    public String getContentTemplate() {
        return this.m_command.getContentTemplate();
    }

    public String getJSP() {
        return this.m_command.getContentTemplate();
    }

    public WikiPage setRealPage(WikiPage page) {
        WikiPage old = this.m_realPage;
        this.m_realPage = page;
        this.updateCommand(this.m_command.getRequestContext());
        return old;
    }

    public WikiPage getRealPage() {
        return this.m_realPage;
    }

    public String getRedirectURL() {
        String pagename = this.m_page.getName();
        String redirURL = null;
        redirURL = this.m_engine.getCommandResolver().getSpecialPageReference(pagename);
        if (redirURL == null) {
            String alias = (String)this.m_page.getAttribute("alias");
            redirURL = alias != null ? this.getViewURL(alias) : (String)this.m_page.getAttribute("redirect");
        }
        return redirURL;
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public WikiPage getPage() {
        return this.m_page;
    }

    public void setPage(WikiPage page) {
        this.m_page = page;
        this.updateCommand(this.m_command.getRequestContext());
    }

    public String getRequestContext() {
        return this.m_command.getRequestContext();
    }

    public void setRequestContext(String arg) {
        this.updateCommand(arg);
    }

    public Object getTarget() {
        return this.m_command.getTarget();
    }

    public String getURLPattern() {
        return this.m_command.getURLPattern();
    }

    public Object getVariable(String key) {
        return this.m_variableMap.get(key);
    }

    public void setVariable(String key, Object data) {
        this.m_variableMap.put(key, data);
        this.updateCommand(this.m_command.getRequestContext());
    }

    public String getHttpParameter(String paramName) {
        String result = null;
        if (this.m_request != null) {
            result = this.m_request.getParameter(paramName);
        }
        return result;
    }

    public HttpServletRequest getHttpRequest() {
        return this.m_request;
    }

    public void setTemplate(String dir) {
        this.m_template = dir;
    }

    public String getName() {
        if (this.m_command instanceof PageCommand) {
            return this.m_page != null ? this.m_page.getName() : "<no page>";
        }
        return this.m_command.getName();
    }

    public String getTemplate() {
        return this.m_template;
    }

    public Principal getCurrentUser() {
        if (this.m_session == null) {
            return WikiPrincipal.GUEST;
        }
        return this.m_session.getUserPrincipal();
    }

    public String getViewURL(String page) {
        return this.getURL(VIEW, page, null);
    }

    public String getURL(String context, String page) {
        return this.getURL(context, page, null);
    }

    public String getURL(String context, String page, String params) {
        boolean absolute = "absolute".equals(this.m_engine.getVariable(this, "jspwiki.referenceStyle"));
        return this.m_engine.getURL(context, page, params, absolute);
    }

    public Command getCommand() {
        return this.m_command;
    }

    public Object clone() {
        try {
            WikiContext copy = (WikiContext)super.clone();
            copy.m_engine = this.m_engine;
            copy.m_command = this.m_command;
            copy.m_template = this.m_template;
            copy.m_variableMap = this.m_variableMap;
            copy.m_request = this.m_request;
            copy.m_session = this.m_session;
            copy.m_page = this.m_page;
            copy.m_realPage = this.m_realPage;
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public WikiContext deepClone() {
        try {
            WikiContext copy = (WikiContext)super.clone();
            copy.m_engine = this.m_engine;
            copy.m_command = this.m_command;
            copy.m_template = this.m_template;
            copy.m_variableMap = (HashMap)this.m_variableMap.clone();
            copy.m_request = this.m_request;
            copy.m_session = this.m_session;
            copy.m_page = (WikiPage)this.m_page.clone();
            copy.m_realPage = (WikiPage)this.m_realPage.clone();
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public WikiSession getWikiSession() {
        return this.m_session;
    }

    public static WikiContext findContext(PageContext pageContext) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        WikiContext context = (WikiContext)request.getAttribute("jspwiki.context");
        return context;
    }

    public Permission requiredPermission() {
        if (WikiCommand.INSTALL.equals(this.m_command)) {
            boolean adminExists = false;
            try {
                UserManager userMgr = this.m_engine.getUserManager();
                UserDatabase userDb = userMgr.getUserDatabase();
                userDb.findByLoginName("admin");
                adminExists = true;
            }
            catch (NoSuchPrincipalException e) {
                return DUMMY_PERMISSION;
            }
            if (adminExists) {
                return new AllPermission(this.m_engine.getApplicationName());
            }
        }
        if (this.m_command.requiredPermission() == null) {
            return DUMMY_PERMISSION;
        }
        return this.m_command.requiredPermission();
    }

    public Command targetedCommand(Object target) {
        if (this.m_command.getTarget() == null) {
            return this.m_command.targetedCommand(target);
        }
        return this.m_command;
    }

    public boolean hasAccess(HttpServletResponse response) throws IOException {
        return this.hasAccess(response, true);
    }

    public boolean hasAccess(HttpServletResponse response, boolean redirect) throws IOException {
        AuthorizationManager mgr = this.m_engine.getAuthorizationManager();
        boolean allowed = mgr.checkPermission(this.m_session, this.requiredPermission());
        ResourceBundle rb = this.getBundle("CoreResources");
        if (allowed && this.m_request != null && this.m_request.getAttribute("jspwiki.context") == null) {
            this.m_request.setAttribute("jspwiki.context", (Object)this);
        }
        if (!allowed && redirect) {
            Principal currentUser = this.m_session.getUserPrincipal();
            Object[] arguments = new Object[]{this.getName()};
            if (this.m_session.isAuthenticated()) {
                log.info((Object)("User " + currentUser.getName() + " has no access - forbidden (permission=" + this.requiredPermission() + ")"));
                String pageurl = this.m_page.getName();
                this.m_session.addMessage(MessageFormat.format(rb.getString("security.error.noaccess.logged"), arguments));
                response.sendRedirect(this.m_engine.getURL(LOGIN, pageurl, null, false));
            } else {
                log.info((Object)("User " + currentUser.getName() + " has no access - redirecting (permission=" + this.requiredPermission() + ")"));
                String pageurl = this.m_page.getName();
                this.m_session.addMessage(MessageFormat.format(rb.getString("security.error.noaccess"), arguments));
                response.sendRedirect(this.m_engine.getURL(LOGIN, pageurl, null, false));
            }
        }
        return allowed;
    }

    public boolean hasAdminPermissions() {
        boolean admin = false;
        admin = this.m_engine.getAuthorizationManager().checkPermission(this.getWikiSession(), new AllPermission(this.m_engine.getApplicationName()));
        return admin;
    }

    protected void setDefaultTemplate(HttpServletRequest request) {
        WikiPage page;
        String defaultTemplate = this.m_engine.getTemplateDir();
        String template = null;
        if (request != null) {
            template = request.getParameter("skin");
        }
        if (template == null && (page = this.getPage()) != null) {
            template = (String)page.getAttribute("jspwiki.templateDir");
        }
        if (template != null) {
            this.setTemplate(template);
        } else {
            this.setTemplate(defaultTemplate);
        }
    }

    protected static Command findCommand(WikiEngine engine, HttpServletRequest request, WikiPage page) {
        String defaultContext = PageCommand.VIEW.getRequestContext();
        Command command = engine.getCommandResolver().findCommand(request, defaultContext);
        if (command instanceof PageCommand && page != null) {
            command = command.targetedCommand(page);
        }
        return command;
    }

    protected void updateCommand(String requestContext) {
        if (requestContext == null) {
            this.m_command = PageCommand.NONE;
        } else {
            CommandResolver resolver = this.m_engine.getCommandResolver();
            this.m_command = resolver.findCommand(this.m_request, requestContext);
        }
        if (this.m_command instanceof PageCommand && this.m_page != null) {
            this.m_command = this.m_command.targetedCommand(this.m_page);
        }
    }

    public ResourceBundle getBundle(String bundle) throws MissingResourceException {
        Locale loc = Preferences.getLocale(this);
        ResourceBundle b = this.m_engine.getInternationalizationManager().getBundle(bundle, loc);
        return b;
    }

    public static Locale getLocale(WikiContext context) {
        return Preferences.getLocale(context);
    }
}

