/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.shutdown;

import ch.qos.logback.core.rolling.shutdown.RollingPolicyShutdownListener;
import com.google.common.collect.Lists;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class RollingPolicyContextListener
implements ServletContextListener {
    private static final List<RollingPolicyShutdownListener> listeners = Lists.newArrayList();

    public static void registerShutdownListener(RollingPolicyShutdownListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void deregisterShutdownListener(RollingPolicyShutdownListener listener) {
        if (listeners.contains(listener)) {
            listeners.remove(listener);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        for (RollingPolicyShutdownListener listener : listeners) {
            listener.doShutdown();
        }
    }
}

