/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.aws;

import ch.qos.logback.core.rolling.data.CustomData;
import ch.qos.logback.core.rolling.shutdown.RollingPolicyShutdownListener;
import ch.qos.logback.core.rolling.util.IdentifierUtil;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmazonS3ClientImpl
implements RollingPolicyShutdownListener {
    private final String awsAccessKey;
    private final String awsSecretKey;
    private final String s3BucketName;
    private final String s3FolderName;
    private final boolean prefixTimestamp;
    private final boolean prefixIdentifier;
    private final String identifier;
    private AmazonS3Client amazonS3Client;
    private ExecutorService executor;

    public AmazonS3ClientImpl(String awsAccessKey, String awsSecretKey, String s3BucketName, String s3FolderName, boolean prefixTimestamp, boolean prefixIdentifier) {
        this.awsAccessKey = awsAccessKey;
        this.awsSecretKey = awsSecretKey;
        this.s3BucketName = s3BucketName;
        this.s3FolderName = s3FolderName;
        this.prefixTimestamp = prefixTimestamp;
        this.prefixIdentifier = prefixIdentifier;
        this.executor = Executors.newFixedThreadPool(1);
        this.amazonS3Client = null;
        this.identifier = prefixIdentifier ? IdentifierUtil.getIdentifier() : null;
    }

    public void uploadFileToS3Async(String filename, Date date) {
        this.uploadFileToS3Async(filename, date, false);
    }

    public void uploadFileToS3Async(String filename, Date date, boolean overrideTimestampSetting) {
        File file;
        if (this.amazonS3Client == null) {
            if (this.getAwsAccessKey() == null || this.getAwsAccessKey().trim().isEmpty()) {
                this.amazonS3Client = new AmazonS3Client();
            } else {
                BasicAWSCredentials cred = new BasicAWSCredentials(this.getAwsAccessKey(), this.getAwsSecretKey());
                this.amazonS3Client = new AmazonS3Client((AWSCredentials)cred);
            }
        }
        if (!(file = new File(filename)).exists() || file.length() == 0L) {
            return;
        }
        final StringBuffer s3ObjectName = new StringBuffer();
        if (this.getS3FolderName() != null) {
            s3ObjectName.append(this.format(this.getS3FolderName(), date)).append("/");
        }
        if (CustomData.extraS3Folder.get() != null) {
            s3ObjectName.append(CustomData.extraS3Folder.get()).append("/");
        }
        if (this.prefixTimestamp || overrideTimestampSetting) {
            s3ObjectName.append(new SimpleDateFormat("yyyyMMdd_HHmmss").format(date)).append("_");
        }
        if (this.prefixIdentifier) {
            s3ObjectName.append(this.identifier).append("_");
        }
        s3ObjectName.append(file.getName());
        Runnable uploader = new Runnable(){

            @Override
            public void run() {
                try {
                    AmazonS3ClientImpl.this.amazonS3Client.putObject(new PutObjectRequest(AmazonS3ClientImpl.this.getS3BucketName(), s3ObjectName.toString(), file).withCannedAcl(CannedAccessControlList.BucketOwnerFullControl));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.executor.execute(uploader);
    }

    @Override
    public void doShutdown() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    private String format(String s, Date date) {
        Pattern pattern = Pattern.compile("%d\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            String match = matcher.group(1);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(match);
            String replace = simpleDateFormat.format(date);
            s = s.replace(String.format("%%d{%s}", match), replace);
        }
        return s;
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public String getS3FolderName() {
        return this.s3FolderName;
    }

    public boolean isPrefixTimestamp() {
        return this.prefixTimestamp;
    }

    public boolean isPrefixIdentifier() {
        return this.prefixIdentifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

