/*
 * Decompiled with CFR 0.152.
 */
package io.millesabords.camel.component.arangodb;

import com.arangodb.ArangoConfigure;
import com.arangodb.ArangoDriver;
import com.arangodb.ArangoHost;
import io.millesabords.camel.component.arangodb.ArangoDbComponent;
import io.millesabords.camel.component.arangodb.ArangoDbProducer;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="arangodb", title="ArangoDB", syntax="arangodb:configBean", producerOnly=true, label="database,nosql")
public class ArangoDbEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ArangoDbEndpoint.class);
    @UriPath
    private String configBean;
    @UriParam
    @Metadata(required="true")
    private String database;
    @UriParam
    private String collection;
    @UriParam
    private String host;
    @UriParam
    private int port;
    @UriParam
    private String operation;
    @UriParam
    private String aql;
    private ArangoDriver driver;
    private ArangoConfigure configure;
    private boolean mustShutdown;

    public ArangoDbEndpoint() {
    }

    public ArangoDbEndpoint(String uri, ArangoDbComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() {
        return new ArangoDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Cannot consume from an ArangoDbEndpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configure == null) {
            this.mustShutdown = true;
            this.configure = new ArangoConfigure();
            this.configure.setArangoHost(new ArangoHost(this.host, this.port));
            this.configure.init();
        }
        this.configure.setDefaultDatabase(this.database);
        this.driver = new ArangoDriver(this.configure);
        LOG.info("Connected to {}:{}, default db is {}", new Object[]{this.host, this.port, this.database});
    }

    protected void doStop() {
        if (this.mustShutdown && this.configure != null) {
            this.configure.shutdown();
        }
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public ArangoDriver getDriver() {
        return this.driver;
    }

    public void setDriver(ArangoDriver driver) {
        this.driver = driver;
    }

    public ArangoConfigure getConfigure() {
        return this.configure;
    }

    public void setConfigure(ArangoConfigure configure) {
        this.configure = configure;
    }

    public boolean isMustShutdown() {
        return this.mustShutdown;
    }

    public void setMustShutdown(boolean mustShutdown) {
        this.mustShutdown = mustShutdown;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getAql() {
        return this.aql;
    }

    public void setAql(String aql) {
        this.aql = aql;
    }

    public String getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(String configBean) {
        this.configBean = configBean;
    }
}

