/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxmetadatalibv2.requests;

import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxmetadatalibv2.utils.BoxMetadataUtils;
import java.util.HashMap;

public class MetadataOperation
extends MapJSONStringEntity {
    private static final long serialVersionUID = 1L;
    private static HashMap<String, Operation> operationMap = new HashMap();
    public static final String OP = "op";
    public static final String PATH = "path";
    public static final String VALUE = "value";

    public MetadataOperation() {
    }

    public MetadataOperation(Operation operation, String key, String value) {
        this.setOperation(operation);
        this.setKey(key);
        this.setValue(value);
    }

    public Operation getOperation() {
        return operationMap.get(this.get(OP));
    }

    protected void setOperation(Operation operation) {
        this.put(OP, operation.toString());
    }

    public String getKey() {
        return MetadataOperation.getKeyFromPath((String)this.get(PATH));
    }

    protected void setKey(String key) {
        this.put(PATH, MetadataOperation.createPath(key));
    }

    public String getValue() {
        return (String)this.get(VALUE);
    }

    protected void setValue(String value) {
        this.put(VALUE, value);
    }

    public String toJSONString(IBoxJSONParser parser) throws BoxJSONException {
        if (this.containsKey(VALUE) && this.getValue() == null) {
            this.remove(VALUE);
        }
        return super.toJSONString(parser);
    }

    private static String createPath(String key) {
        return '/' + BoxMetadataUtils.escapeJSONPointerKey(key);
    }

    private static String getKeyFromPath(String path) {
        return path.substring(1);
    }

    static {
        for (Operation op : Operation.values()) {
            operationMap.put(op.toString(), op);
        }
    }

    public static enum Operation {
        ADD,
        REMOVE,
        TEST,
        REPLACE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

