/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxmetadatalibv2.example;

import com.box.boxjavalibv2.BoxClient;
import com.box.boxjavalibv2.dao.BoxFile;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxmetadatalibv2.BoxFileMetadataPlugin;
import com.box.boxmetadatalibv2.IBoxFileMetadataManager;
import com.box.boxmetadatalibv2.dao.BoxFileMetadata;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxFileUploadRequestObject;
import com.box.restclientv2.requestsbase.MetadataJSONPatchRequestObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class HelloMetadata {
    private final BoxClient client;

    public HelloMetadata(BoxClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws BoxRestException, BoxServerException, AuthFatalFailureException, InterruptedException, BoxJSONException {
        String fileContent = "abc";
        ByteArrayInputStream is = new ByteArrayInputStream(fileContent.getBytes());
        BoxFile bFile = null;
        try {
            bFile = this.client.getFilesManager().uploadFile(BoxFileUploadRequestObject.uploadFileRequestObject((String)"0", (String)("a" + System.currentTimeMillis()), (InputStream)is));
            String fileId = bFile.getId();
            this.metadataSample(fileId);
        }
        finally {
            if (bFile != null) {
                this.client.getFilesManager().deleteFile(bFile.getId(), null);
            }
        }
    }

    private void metadataSample(String fileId) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        BoxFileMetadataPlugin plugin = new BoxFileMetadataPlugin();
        IBoxFileMetadataManager manager = plugin.plugin(this.client);
        String key1 = "key0";
        String value1 = "value0";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key1, value1);
        BoxFileMetadata meta = manager.createMetadata(fileId, "properties", map);
        System.out.println(String.format("metadata added,{key, value}:{%s,%s}", key1, value1));
        meta = manager.getMetadata(fileId, "properties", null);
        Map<String, String> metamap = meta.getAllMetadata();
        System.out.println("retrieved metadata:");
        this.printMap(metamap);
        key1 = "key1";
        value1 = "value1";
        meta = manager.updateMetadata(fileId, "properties", key1, value1);
        System.out.println(String.format("metadata added,{key, value}:{%s,%s}", key1, value1));
        meta = manager.getMetadata(fileId, "properties", null);
        metamap = meta.getAllMetadata();
        System.out.println("retrieved metadata:");
        this.printMap(metamap);
        System.out.println("test should pass");
        meta = manager.testMetadata(fileId, "properties", key1, value1);
        System.out.println("test passed");
        try {
            System.out.println("test should fail");
            meta = manager.testMetadata(fileId, "properties", key1, "blablabla");
        }
        catch (BoxServerException e) {
            System.out.println("test failed");
        }
        MetadataJSONPatchRequestObject obj = MetadataJSONPatchRequestObject.testOperation(key1, value1);
        obj.appendAddOperation("something", "somevalue");
        manager.executeBatchMetadataRequest(fileId, "properties", obj);
        meta = manager.getMetadata(fileId, "properties", null);
        metamap = meta.getAllMetadata();
        System.out.println("retrieved metadata:");
        this.printMap(metamap);
        MetadataJSONPatchRequestObject obj2 = MetadataJSONPatchRequestObject.testOperation(key1, "blablabla");
        obj.appendAddOperation("somethingelse", "somevalueelse");
        try {
            manager.executeBatchMetadataRequest(fileId, "properties", obj2);
        }
        catch (BoxServerException e) {
            System.out.println("test failed");
        }
        meta = manager.getMetadata(fileId, "properties", null);
        metamap = meta.getAllMetadata();
        System.out.println("retrieved metadata:");
        this.printMap(metamap);
    }

    private void printMap(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            System.out.println(entry.getKey() + "," + entry.getValue());
        }
    }
}

