/*
 * Decompiled with CFR 0.152.
 */
package com.dzer6.box.generator;

import com.box.boxjavalibv2.dao.BoxObject;
import com.google.common.collect.Maps;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.ParameterContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.ReflectionException;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BoxObjectGenerator<T extends BoxObject>
extends Generator<T> {
    public static final String FIELD_PREFIX = "FIELD_";
    public static final String GET = "get";
    public static final String IS = "is";
    public static final String UNDERSCORE = "_";
    public static final String EMPTY = "";
    public static final int FIELD_PREFIX_LENGTH = "FIELD_".length();

    public BoxObjectGenerator(Class<T> type) {
        super(type);
    }

    public T generate(SourceOfRandomness random, GenerationStatus status) {
        Class type = (Class)this.types().get(0);
        HashMap map = Maps.newHashMap();
        for (Field field : Reflection.allDeclaredFieldsOf((Class)type)) {
            String name = field.getName();
            if (!name.contains(FIELD_PREFIX)) continue;
            String key = name.substring(FIELD_PREFIX_LENGTH, name.length()).toLowerCase();
            Object value = this.generateValue(random, status, type, key);
            map.put(key, value);
        }
        try {
            return (T)((BoxObject)Reflection.instantiate(type.getConstructor(Map.class), (Object[])new Object[]{map}));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return (T)((BoxObject)Reflection.instantiate((Class)type));
        }
    }

    protected Object generateValue(SourceOfRandomness random, GenerationStatus status, Class<T> type, String key) {
        Class<?> returnType = this.getMethodReturnType(type, key);
        return this.generateValue(random, status, returnType);
    }

    protected <E> E generateValue(SourceOfRandomness random, GenerationStatus status, Class<E> type) {
        ParameterContext parameter = new ParameterContext(type);
        Generator generator = this.generatorFor(parameter);
        return (E)generator.generate(random, status);
    }

    protected Class<?> getMethodReturnType(Class<T> type, String key) {
        String camelCase = this.toCamelCase(key);
        try {
            return Reflection.findMethod(type, (String)(GET + camelCase), (Class[])new Class[0]).getReturnType();
        }
        catch (ReflectionException exOne) {
            try {
                return Reflection.findMethod(type, (String)(IS + camelCase), (Class[])new Class[0]).getReturnType();
            }
            catch (ReflectionException exTwo) {
                return Reflection.findMethod(type, (String)this.firstCharToLowerCase(camelCase), (Class[])new Class[0]).getReturnType();
            }
        }
    }

    protected String toCamelCase(String s) {
        String[] parts = s.split(UNDERSCORE);
        String camelCaseString = EMPTY;
        for (String part : parts) {
            camelCaseString = camelCaseString + this.toProperCase(part);
        }
        return camelCaseString;
    }

    protected String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    protected String firstCharToLowerCase(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }
}

