/*
 * Decompiled with CFR 0.152.
 */
package com.dropwizard.hibernate.transaction;

import com.dropwizard.hibernate.transaction.TransactionHandler;
import com.dropwizard.hibernate.transaction.Transactional;
import com.dropwizard.hibernate.transaction.utils.ManagedContext;
import java.lang.reflect.InvocationTargetException;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class TransactionalAspect {
    private static final String INIATIATED = "initiated";
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ TransactionalAspect ajc$perSingletonInstance;

    @Pointcut(value="within(@com.dropwizard.hibernate.transaction.Transactional *)")
    public /* synthetic */ void transcationClassCalled() {
    }

    @Pointcut(value="@annotation(com.dropwizard.hibernate.transaction.Transactional)")
    public /* synthetic */ void transcationFunctionCalled() {
    }

    @Pointcut(value="execution(* *(..))")
    public /* synthetic */ void anyFunctionCalled() {
    }

    @Around(value="(transcationClassCalled() &&  anyFunctionCalled()) || (transcationFunctionCalled() && anyFunctionCalled())")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Transactional transactional;
        Signature callSignature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)MethodSignature.class.cast(callSignature);
        Transactional monitoredFunction = methodSignature.getMethod().getAnnotation(Transactional.class);
        Transactional classTransactional = callSignature.getDeclaringType().getAnnotation(Transactional.class);
        Transactional transactional2 = transactional = monitoredFunction == null ? classTransactional : monitoredFunction;
        if (ManagedContext.existKey(INIATIATED)) {
            return joinPoint.proceed();
        }
        return this.handleTransaction(transactional, joinPoint);
    }

    private Object handleTransaction(Transactional transactional, ProceedingJoinPoint joinPoint) throws Throwable {
        TransactionHandler transactionHandler = new TransactionHandler();
        try {
            transactionHandler.beforeStart(transactional);
            ManagedContext.put(INIATIATED, "true");
            Object result = joinPoint.proceed();
            transactionHandler.afterEnd();
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e) {
            transactionHandler.onError();
            throw e.getCause();
        }
        catch (Exception e) {
            transactionHandler.onError();
            throw e;
        }
        finally {
            ManagedContext.remove(INIATIATED);
            transactionHandler.onFinish();
        }
    }

    public static TransactionalAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.dropwizard.hibernate.transaction.TransactionalAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            TransactionalAspect.ajc$perSingletonInstance = new TransactionalAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

