/*
 * Decompiled with CFR 0.152.
 */
package com.dropwizard.hibernate.transaction;

import com.dropwizard.hibernate.transaction.Transactional;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

public class TransactionHandler {
    private static SessionFactory sessionFactory;
    @Nullable
    private Transactional transactional;
    @Nullable
    private Session session;

    public static void initialize(SessionFactory initSessionFactory) {
        sessionFactory = initSessionFactory;
    }

    public static SessionFactory getSessionFactory() {
        return Objects.requireNonNull(sessionFactory);
    }

    public void beforeStart(@Nullable Transactional transactional) {
        if (transactional == null) {
            return;
        }
        this.transactional = transactional;
        if (sessionFactory == null) {
            throw new IllegalArgumentException("Unregistered Hibernate bundle: ");
        }
        this.session = sessionFactory.openSession();
        try {
            this.configureSession();
            ManagedSessionContext.bind((Session)this.session);
            this.beginTransaction(transactional, this.session);
        }
        catch (Throwable th) {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)sessionFactory);
            throw th;
        }
    }

    public void afterEnd() {
        if (this.transactional == null || this.session == null) {
            return;
        }
        try {
            this.commitTransaction(this.transactional, this.session);
        }
        catch (Exception e) {
            this.rollbackTransaction(this.transactional, this.session);
            throw e;
        }
    }

    public void onError() {
        if (this.transactional == null || this.session == null) {
            return;
        }
        try {
            this.rollbackTransaction(this.transactional, this.session);
        }
        finally {
            this.onFinish();
        }
    }

    public void onFinish() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        finally {
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)sessionFactory);
        }
    }

    protected void configureSession() {
        Preconditions.checkNotNull((Object)this.transactional);
        Preconditions.checkNotNull((Object)this.session);
        this.session.setDefaultReadOnly(this.transactional.readOnly());
        this.session.setCacheMode(this.transactional.cacheMode());
        this.session.setHibernateFlushMode(this.transactional.flushMode());
    }

    private void beginTransaction(Transactional transactional, Session session) {
        if (!transactional.transactional()) {
            return;
        }
        session.beginTransaction();
    }

    private void rollbackTransaction(Transactional transactional, Session session) {
        if (!transactional.transactional()) {
            return;
        }
        Transaction txn = session.getTransaction();
        if (txn != null && txn.getStatus().canRollback()) {
            txn.rollback();
        }
    }

    private void commitTransaction(Transactional transactional, Session session) {
        if (!transactional.transactional()) {
            return;
        }
        Transaction txn = session.getTransaction();
        if (txn != null && txn.getStatus().canRollback()) {
            txn.commit();
        }
    }

    protected Session getSession() {
        return Objects.requireNonNull(this.session);
    }
}

