/*
 * Decompiled with CFR 0.152.
 */
package com.dropwizard.hibernate.transaction;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.util.concurrent.MoreExecutors;
import io.dropwizard.db.TimeBoundHealthCheck;
import io.dropwizard.util.Duration;
import java.util.concurrent.ExecutorService;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class SessionFactoryHealthCheck
extends HealthCheck {
    private final SessionFactory sessionFactory;
    private final String validationQuery;
    private final TimeBoundHealthCheck timeBoundHealthCheck;

    public SessionFactoryHealthCheck(SessionFactory sessionFactory, String validationQuery) {
        this((ExecutorService)MoreExecutors.newDirectExecutorService(), Duration.seconds((long)0L), sessionFactory, validationQuery);
    }

    public SessionFactoryHealthCheck(ExecutorService executorService, Duration duration, SessionFactory sessionFactory, String validationQuery) {
        this.sessionFactory = sessionFactory;
        this.validationQuery = validationQuery;
        this.timeBoundHealthCheck = new TimeBoundHealthCheck(executorService, duration);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    protected HealthCheck.Result check() throws Exception {
        return this.timeBoundHealthCheck.check(() -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Session session = this.sessionFactory.openSession();){
                Transaction txn = session.beginTransaction();
                try {
                    session.createNativeQuery(this.validationQuery).list();
                    txn.commit();
                }
                catch (Exception e) {
                    if (txn.getStatus().canRollback()) {
                        txn.rollback();
                    }
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return HealthCheck.Result.healthy();
        });
    }
}

