/*
 * Decompiled with CFR 0.152.
 */
package com.dropwizard.hibernate.transaction;

import com.dropwizard.hibernate.transaction.TransactionHandler;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.CriteriaQuery;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.query.internal.AbstractProducedQuery;

public abstract class AbstractDAO<E> {
    private final Class<?> entityClass = this.getClass();

    protected Session currentSession() {
        return TransactionHandler.getSessionFactory().getCurrentSession();
    }

    protected CriteriaQuery<E> criteriaQuery() {
        return this.currentSession().getCriteriaBuilder().createQuery(this.getEntityClass());
    }

    protected Query namedQuery(String queryName) throws HibernateException {
        return this.currentSession().getNamedQuery(Objects.requireNonNull(queryName));
    }

    protected Query<E> query(String queryString) {
        return this.currentSession().createQuery(Objects.requireNonNull(queryString), this.getEntityClass());
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected E uniqueResult(CriteriaQuery<E> criteriaQuery) throws HibernateException {
        return (E)AbstractProducedQuery.uniqueElement((List)this.currentSession().createQuery(Objects.requireNonNull(criteriaQuery)).getResultList());
    }

    protected E uniqueResult(Criteria criteria) throws HibernateException {
        return (E)Objects.requireNonNull(criteria).uniqueResult();
    }

    protected E uniqueResult(Query<E> query) throws HibernateException {
        return (E)Objects.requireNonNull(query).uniqueResult();
    }

    protected List<E> list(Criteria criteria) throws HibernateException {
        return Objects.requireNonNull(criteria).list();
    }

    protected List<E> list(CriteriaQuery<E> criteria) throws HibernateException {
        return this.currentSession().createQuery(Objects.requireNonNull(criteria)).getResultList();
    }

    protected List<E> list(Query<E> query) throws HibernateException {
        return Objects.requireNonNull(query).list();
    }

    protected E get(Serializable id) {
        return (E)this.currentSession().get(this.entityClass, Objects.requireNonNull(id));
    }

    protected E persist(E entity) throws HibernateException {
        this.currentSession().saveOrUpdate(Objects.requireNonNull(entity));
        return entity;
    }
}

