(ns norville.routes
  (:require [compojure.core :as cj]
            [compojure.core :refer [GET POST PUT DELETE]]))

;; cd ~/src/elasticsearch; git grep \.registerHandler \
;;   | egrep -o '(GET|PUT|POST|DELETE), "[^"]+"'
;;   | sed -e 's/, / /' -e 's_{\([^}]*\)}_:\1_g' \
;;   | sort -k2 | perl -pe 's,(.*),($1 _ _),'

(def routes
  (cj/routes
   (DELETE  "/" _ _)
   (GET     "/" _ _)
   (DELETE  ["/:index", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index", :index #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index", :index #"[^_][^/?]*?"] _ _)
   (DELETE  ["/:index/:type", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (DELETE  ["/:index/:type/:id", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/:id", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/:id", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/:type/:id", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/:id/_create", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/:type/:id/_create", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/:id/_explain", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/:id/_mlt", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/:id/_mlt", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/:id/_update", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/_bulk", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/:type/_bulk", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/_count", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/_count", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (DELETE  ["/:index/:type/_mapping", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/_mapping", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/_mapping", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/:type/_mapping", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/_mget", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/_mget", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/_msearch", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/_msearch", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/_percolate", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/_percolate", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (DELETE  ["/:index/:type/_query", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/_search", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/_search", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/_validate/query", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/:type/_validate/query", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (DELETE  ["/:index/:type/_warmer/:name", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/:type/_warmer/:name", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/:type/_warmer/:name", :index #"[^_][^/?]*?" :type #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_aliases", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_analyze", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_analyze", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_bulk", :index #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/_bulk", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_cache/clear", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_cache/clear", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_close", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_count", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_count", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_flush", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_flush", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_gateway/snapshot", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_mapping", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_mapping", :index #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/_mapping", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_mget", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_mget", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_msearch", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_msearch", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_open", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_optimize", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_optimize", :index #"[^_][^/?]*?"] _ _)
   (DELETE  ["/:index/_query", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_refresh", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_refresh", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_search", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_search", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_segments", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_settings", :index #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/_settings", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/docs", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/flush", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/get", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/indexing", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/indexing/:indexingTypes2", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/merge", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/refresh", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/search", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/search/:searchGroupsStats2", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/store", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_stats/warmer", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_status", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_validate/query", :index #"[^_][^/?]*?"] _ _)
   (POST    ["/:index/_validate/query", :index #"[^_][^/?]*?"] _ _)
   (DELETE  ["/:index/_warmer", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_warmer", :index #"[^_][^/?]*?"] _ _)
   (DELETE  ["/:index/_warmer/:name", :index #"[^_][^/?]*?"] _ _)
   (GET     ["/:index/_warmer/:name", :index #"[^_][^/?]*?"] _ _)
   (PUT     ["/:index/_warmer/:name", :index #"[^_][^/?]*?"] _ _)
   (GET     "/_aliases" _ _)
   (POST    "/_aliases" _ _)
   (GET     "/_analyze" _ _)
   (POST    "/_analyze" _ _)
   (POST    "/_bulk" _ _)
   (PUT     "/_bulk" _ _)
   (GET     "/_cache/clear" _ _)
   (POST    "/_cache/clear" _ _)
   (GET     "/_cluster/health" _ _)
   (GET     "/_cluster/health/:index" _ _)
   (GET     "/_cluster/nodes" _ _)
   (GET     "/_cluster/nodes/:nodeId" _ _)
   (POST    "/_cluster/nodes/:nodeId/_restart" _ _)
   (POST    "/_cluster/nodes/:nodeId/_shutdown" _ _)
   (GET     "/_cluster/nodes/:nodeId/hot_threads" _ _)
   (GET     "/_cluster/nodes/:nodeId/hotthreads" _ _)
   (GET     "/_cluster/nodes/:nodeId/stats" _ _)
   (POST    "/_cluster/nodes/_restart" _ _)
   (POST    "/_cluster/nodes/_shutdown" _ _)
   (GET     "/_cluster/nodes/hot_threads" _ _)
   (GET     "/_cluster/nodes/hotthreads" _ _)
   (GET     "/_cluster/nodes/stats" _ _)
   (POST    "/_cluster/reroute" _ _)
   (GET     "/_cluster/settings" _ _)
   (PUT     "/_cluster/settings" _ _)
   (GET     "/_cluster/state" _ _)
   (GET     "/_count" _ _)
   (POST    "/_count" _ _)
   (GET     "/_flush" _ _)
   (POST    "/_flush" _ _)
   (POST    "/_gateway/snapshot" _ _)
   (GET     "/_mapping" _ _)
   (GET     "/_mget" _ _)
   (POST    "/_mget" _ _)
   (GET     "/_msearch" _ _)
   (POST    "/_msearch" _ _)
   (GET     "/_nodes" _ _)
   (GET     "/_nodes/:nodeId" _ _)
   (GET     "/_nodes/:nodeId/fs/stats" _ _)
   (GET     "/_nodes/:nodeId/hot_threads" _ _)
   (GET     "/_nodes/:nodeId/hotthreads" _ _)
   (GET     "/_nodes/:nodeId/http" _ _)
   (GET     "/_nodes/:nodeId/http/stats" _ _)
   (GET     "/_nodes/:nodeId/indices/stats" _ _)
   (GET     "/_nodes/:nodeId/jvm" _ _)
   (GET     "/_nodes/:nodeId/jvm/stats" _ _)
   (GET     "/_nodes/:nodeId/network" _ _)
   (GET     "/_nodes/:nodeId/network/stats" _ _)
   (GET     "/_nodes/:nodeId/os" _ _)
   (GET     "/_nodes/:nodeId/os/stats" _ _)
   (GET     "/_nodes/:nodeId/process" _ _)
   (GET     "/_nodes/:nodeId/process/stats" _ _)
   (GET     "/_nodes/:nodeId/settings" _ _)
   (GET     "/_nodes/:nodeId/stats" _ _)
   (GET     "/_nodes/:nodeId/stats/fs" _ _)
   (GET     "/_nodes/:nodeId/stats/http" _ _)
   (GET     "/_nodes/:nodeId/stats/indices" _ _)
   (GET     "/_nodes/:nodeId/stats/jvm" _ _)
   (GET     "/_nodes/:nodeId/stats/network" _ _)
   (GET     "/_nodes/:nodeId/stats/os" _ _)
   (GET     "/_nodes/:nodeId/stats/process" _ _)
   (GET     "/_nodes/:nodeId/stats/thread_pool" _ _)
   (GET     "/_nodes/:nodeId/stats/transport" _ _)
   (GET     "/_nodes/:nodeId/thread_pool" _ _)
   (GET     "/_nodes/:nodeId/thread_pool/stats" _ _)
   (GET     "/_nodes/:nodeId/transport" _ _)
   (GET     "/_nodes/:nodeId/transport/stats" _ _)
   (GET     "/_nodes/fs/stats" _ _)
   (GET     "/_nodes/hot_threads" _ _)
   (GET     "/_nodes/hotthreads" _ _)
   (GET     "/_nodes/http" _ _)
   (GET     "/_nodes/http/stats" _ _)
   (GET     "/_nodes/indices/stats" _ _)
   (GET     "/_nodes/jvm" _ _)
   (GET     "/_nodes/jvm/stats" _ _)
   (GET     "/_nodes/network" _ _)
   (GET     "/_nodes/network/stats" _ _)
   (GET     "/_nodes/os" _ _)
   (GET     "/_nodes/os/stats" _ _)
   (GET     "/_nodes/process" _ _)
   (GET     "/_nodes/process/stats" _ _)
   (GET     "/_nodes/settings" _ _)
   (GET     "/_nodes/stats" _ _)
   (GET     "/_nodes/stats/fs" _ _)
   (GET     "/_nodes/stats/http" _ _)
   (GET     "/_nodes/stats/indices" _ _)
   (GET     "/_nodes/stats/jvm" _ _)
   (GET     "/_nodes/stats/network" _ _)
   (GET     "/_nodes/stats/os" _ _)
   (GET     "/_nodes/stats/process" _ _)
   (GET     "/_nodes/stats/thread_pool" _ _)
   (GET     "/_nodes/stats/transport" _ _)
   (GET     "/_nodes/thread_pool" _ _)
   (GET     "/_nodes/thread_pool/stats" _ _)
   (GET     "/_nodes/transport" _ _)
   (GET     "/_nodes/transport/stats" _ _)
   (GET     "/_optimize" _ _)
   (POST    "/_optimize" _ _)
   (GET     "/_refresh" _ _)
   (POST    "/_refresh" _ _)
   (GET     "/_search" _ _)
   (POST    "/_search" _ _)
   (GET     "/_search/scroll" _ _)
   (POST    "/_search/scroll" _ _)
   (GET     "/_search/scroll/:scroll_id" _ _)
   (POST    "/_search/scroll/:scroll_id" _ _)
   (GET     "/_segments" _ _)
   (GET     "/_settings" _ _)
   (PUT     "/_settings" _ _)
   (POST    "/_shutdown" _ _)
   (GET     "/_stats" _ _)
   (GET     "/_stats/flush" _ _)
   (GET     "/_stats/get" _ _)
   (GET     "/_stats/indexing" _ _)
   (GET     "/_stats/indexing/:indexingTypes1" _ _)
   (GET     "/_stats/merge" _ _)
   (GET     "/_stats/refresh" _ _)
   (GET     "/_stats/search" _ _)
   (GET     "/_stats/search/:searchGroupsStats1" _ _)
   (GET     "/_stats/store" _ _)
   (GET     "/_stats/warmer" _ _)
   (GET     "/_status" _ _)
   (DELETE  "/_template/:name" _ _)
   (GET     "/_template/:name" _ _)
   (POST    "/_template/:name" _ _)
   (PUT     "/_template/:name" _ _)
   (GET     "/_validate/query" _ _)
   (POST    "/_validate/query" _ _)
   (GET     "_stats/docs" _ _)))

(defn params [meth uri]
  (:params (routes {:request-method meth :uri uri})))
