(ns domkm.silk.serve
  (:require [clojure.string :as str]
            [domkm.silk :as silk])
        
  (:require-macros [domkm.silk.serve :refer [def-request-methods]])
       
                              )


     
                                                                                          
                             
                                                            
                               
                                    
                                                
                  
                 

     
                  
                                                                                                 
                                                                                      
                                       
                          
                                     
                                           
                                      
                                                                                                      
           
                                  
                       
                                   
              
                                                                  
                                                  
                                          


;;;; Request Method Pattern ;;;;

(deftype ^:private RequestMethodPattern [method opt?]
  silk/Pattern
  (-match [_ mthd]
          (when (or (                        keyword-identical? method mthd)
                    (and opt? (nil? mthd)))
            {}))
  (-unmatch [_ _]
            (when-not opt?
              method))
  (-match-validator [_]
                    (if opt?
                      (some-fn nil? keyword?)
                      keyword?))
  (-unmatch-validators [_]
                       {})
  IFn
  (                    -invoke [this]
         {:request-method this})
  (                    -invoke [this url-ptrn]
         (assoc (silk/url-pattern url-ptrn) :request-method this)))

                                               
           
                        
                                
                                                                            
                                                      

(def-request-methods #{:delete :get :head :options :post :put})

;;;;;;;;;;;; This file autogenerated from src/domkm/silk/serve.cljx
