(ns doccla.oth-client.idp2.clients.auth
  (:require [doccla.oth-client.schemas :as schemas]
            [malli.clj-kondo :as clj-kondo]
            [malli.core :as m]
            [malli.instrument :as mi]
            [doccla.oth-client.utils :as utils]
            [clj-http.client :as client]))

(def client-token-schema
  [:map
   [:exp int?]
   [:type [:enum "Bearer"]]
   [:token string?]
   [:links [:map [:logout [:re schemas/url-regex]]]]])

(defn post-processor
  [opts schema]
  (fn [data]
    (let [f (if (:validate-output? opts) m/coerce m/decode)]
      (f schema data utils/prune-map-transformer))))

(defn ^:mockable get-client-auth
  "Get an OTH issued JWT for a client"
  [opts]
  (let [res (client/get (str (:base-url opts) "/idp2/clients/auth")
                        (utils/opts->request opts))]
    (utils/->output [200] (post-processor opts client-token-schema) res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}
                 :report utils/input-validate-fail!})
(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)
