(ns doccla.oth-client.generic
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.utils :as utils]
   [clojure.string :as str]))

(defn ^:mockable request
  "Make a generic request to the OTH API.
   
   opts - Standard OTH client options map with :base-url and :auth
   method - HTTP method (:get, :post, :put, :delete)
   path - Path to append to base-url (or full URL)
   params - Optional map of query parameters
   body - Optional body for POST/PUT requests"
  ([opts method path]
   (request opts method path nil nil))
  ([opts method path params]
   (request opts method path params nil))
  ([opts method path params body]
   (let [url (if (str/starts-with? path "http")
               path
               (str (:base-url opts) path))
         req (cond-> (utils/opts->request opts)
               params (assoc :query-params params
                             :multi-param-style :array)
               body (merge (utils/opts->request-with-body opts body)))
         res (case method
               :get (client/get url req)
               :post (client/post url req)
               :put (client/put url req)
               :delete (client/delete url req))]
     ;; Always return raw response with basic success/error info
     (utils/->output [200 201 204] identity res))))

;; Enable mocks
(utils/make-mockable)