(ns doccla.oth-client.chat.threads
  (:require [clj-http.client :as client]
            [doccla.oth-client.schemas :as schemas]
            [doccla.oth-client.utils :as utils]
            [malli.clj-kondo :as clj-kondo]
            [malli.core :as m]
            [malli.instrument :as mi]))

(def query-params-schema
  [:map
   [:patient {:optional true} [:re schemas/url-regex]]
   [:offset {:optional true} int?]
   [:max {:optional true} int?]])

(def thread-schema
  [:map
   [:latest-message-at [:re schemas/iso-8601-regex]]
   [:links [:map
            [:messages [:re schemas/url-regex]]
            [:organization [:re schemas/url-regex]]
            [:patient [:re schemas/url-regex]]
            [:thread [:re schemas/url-regex]]]]
   [:organization-name string?]
   [:unread-from-organization int?]
   [:unread-from-patient int?]])

(def threads-schema
  [:map
   [:total int?]
   [:max int?]
   [:offset int?]
   [:results [:vector thread-schema]]
   [:links [:map
            [:self [:re schemas/url-regex]]
            [:next {:optional true} [:re schemas/url-regex]]
            [:previous {:optional true} [:re schemas/url-regex]]]]])

(m/=> get-threads [:=>
                   [:cat schemas/opts-schema query-params-schema]
                   [:or schemas/error-schema (schemas/success-schema threads-schema)]])

(defn ^:mockable get-threads
  "Retrieve a list of chat message threads"
  [opts params]
  (let [res (client/get (str (:base-url opts) "/chat/threads")
                        (assoc (utils/opts->request opts)
                               :query-params params))
        post-processor (fn [data] (let [f (if (:validate-output? opts) m/coerce m/decode)]
                                    (f threads-schema data utils/prune-map-transformer)))]
    (utils/->output [200] post-processor res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}
                 :report utils/input-validate-fail!})
(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)

(comment
 ;; Example usage
  #_:clj-kondo/ignore
  (get-threads {:base-url "https://doccla-dev.oth.io"
                :validate-output? true
                :auth {:type :id-secret :id "" :secret ""}}
               {:patient "https://doccla-dev.oth.io/clinician/api/patients/37" :max 300}))