(ns doccla.oth-client.idp2.users.locked
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.utils :as utils]
   [doccla.oth-client.schemas :as schemas]
   [malli.clj-kondo :as clj-kondo]
   [malli.core :as m]
   [malli.instrument :as mi]))

(def update-params-schema
  [:map
   [:account-locked boolean?]])

(def update-response-schema
  [:map
   [:account-locked boolean?]
   [:links
    [:map
     [:user string?]]]])

(m/=> update-locked [:=>
                     [:cat schemas/opts-schema [:or :string :int] update-params-schema]
                     [:or schemas/error-schema (schemas/success-schema update-response-schema)]])

(defn post-processor
  [opts schema]
  (fn [data]
    (let [f (if (:validate-output? opts) m/coerce m/decode)]
      (f schema data utils/prune-map-transformer))))

(defn ^:mockable update-locked
  "Set the locked status of a user."
  [opts id body]
  (let [req (utils/opts->request-with-body opts body)
        res (client/put (str (:base-url opts) "/idp2/users/" id "/locked") req)]
    (utils/->output [200] (post-processor opts update-response-schema) res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}
                 :report utils/input-validate-fail!})
(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)