(ns doccla.oth-client.idp2.users.auth
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.utils :as utils]
   [doccla.oth-client.schemas :as schemas]
   [malli.clj-kondo :as clj-kondo]
   [malli.core :as m]
   [malli.instrument :as mi]))

(def post-user-auth-body-schema
  [:map [:password string?]])

(def post-user-auth-response-schema
  [:map
   [:exp int?]
   [:type [:enum "Bearer"]]
   [:token string?]
   [:refresh-token string?]
   [:custom-claims map?]
   [:links [:map [:logout [:re schemas/url-regex]]]]])

(defn post-processor
  [opts schema]
  (fn [data]
    (let [f (if (:validate-output? opts) m/coerce m/decode)]
      (f schema data utils/prune-map-transformer))))

(m/=> post-user-auth [:=>
                      [:cat schemas/opts-schema post-user-auth-body-schema]
                      [:or schemas/error-schema (schemas/success-schema post-user-auth-response-schema)]])

(defn ^:mockable post-user-auth
  "Changes the password of a user."
  [opts body]
  (let [url (str (:base-url opts) "/idp2/users/auth")
        res (client/post url (merge utils/default-request-map {:basic-auth [(:identity (:auth opts)) (:password (:auth opts))]
                                                               :body (utils/encode body)
                                                               :headers {:content-type "application/json"}}))]
    (utils/->output [200] (post-processor opts post-user-auth-response-schema) res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}
                 :report utils/input-validate-fail!})
(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)

(comment
  (def opts {:base-url    "https://doccla-dev.oth.io"
             :validate-output? true
             :auth {:type :identity-password :identity "" :password ""}})

  (post-user-auth opts {:password ""}))