(ns doccla.oth-client.idp2.tokens
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.utils :as utils]
   [malli.clj-kondo :as clj-kondo]
   [malli.core :as m]
   [malli.instrument :as mi]))

(def token-schema
  [:map
   [:exp int?]
   [:type string?]
   [:token string?]
   [:links [:map
            [:logout string?]]]
   [:custom-claims [:map
                    [:organizations [:vector [:map
                                              [:name string?]
                                              [:url string?]]]]
                    [:patient-groups [:vector [:map
                                               [:name string?]
                                               [:url string?]]]]]]])

(defn post-processor
  [opts schema]
  (fn [data]
    (let [f (if (:validate-output? opts) m/coerce m/decode)]
      (f schema data utils/prune-map-transformer))))

(defn ^:mockable verify-token
  "Verify whether an OTH issued JWT is valid.
   There is no 'exp' claim in the JWT so this function is the only way to reliably
   tell whether the token is valid"
  [opts token]
  (let [res (client/get (str (:base-url opts) "/idp2/tokens")
                        (assoc (utils/opts->request opts)
                               :headers {"App-Token" token}))]
    (utils/->output [200] (post-processor opts token-schema) res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope   #{:input}
                 :report  utils/input-validate-fail!})
(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)
