(ns doccla.oth-client.clinician.api.patient-groups
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.schemas :as schemas]
   [doccla.oth-client.utils :as utils]
   [malli.clj-kondo :as clj-kondo]
   [malli.core :as m]
   [malli.instrument :as mi]))

(def patient-group-schema
  [:map
   [:name string?]
   [:messaging-enabled {:optional true} boolean?]
   [:blue-alarms-enabled {:optional true} boolean?]
   [:continuous-ctg-enabled {:optional true} boolean?]
   [:due-date-visible {:optional true} boolean?]
   [:copd-prediction {:optional true} boolean?]
   [:calculate-blood-pressure-weekly-average {:optional true} boolean?]
   [:links [:map [:self string?]
            [:organization string?]]]])

(m/=> get-patient-group [:=>
                         [:cat schemas/opts-schema [:or :string :int]]
                         [:or schemas/error-schema (schemas/success-schema patient-group-schema)]])

(defn ^:mockable get-patient-group
  "Get a patient group by ID."
  [opts patient-group-id]
  (let [res (client/get (str (:base-url opts) "/clinician/api/patientgroups/" patient-group-id)
                        (utils/opts->request opts))
        post-processor (fn [data] (let [f (if (:validate-output? opts) m/coerce m/decode)]
                                    (f patient-group-schema data utils/prune-map-transformer)))]
    (utils/->output [200] post-processor res)))

(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}
                 :report utils/input-validate-fail!})

(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)

(comment
  (require '[clojure.edn :as edn])
  (def creds (edn/read-string (slurp "creds/oth.edn")))
  (def opts {:base-url    "https://doccla-dev.oth.io"
             :validate-output? true
             :auth {:type :id-secret :id (:id creds) :secret (:secret creds)}})
  (get-patient-group opts 120))