(ns doccla.oth-client.clinician.api.measurements
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.utils :as utils]
   [malli.clj-kondo :as clj-kondo]
   [malli.core :as m]
   [malli.instrument :as mi]
   [doccla.oth-client.schemas :as schemas]))

(def query-params-schema
  [:map
   [:type {:optional true} [:enum schemas/measurement-types-enum]]
   [:ignored {:optional true} boolean?]
   [:isBeforeMeal {:optional true} boolean?]
   [:isAfterMeal {:optional true} boolean?]
   [:isFasting {:optional true} boolean?]
   [:offset {:optional true} int?]
   [:max {:optional true} int?]
   [:from {:optional true} [:re schemas/iso-8601-regex]]
   [:to {:optional true} [:re schemas/iso-8601-regex]]])

(m/=> get-measurements [:=>
                        [:cat schemas/opts-schema query-params-schema]
                        [:or schemas/error-schema (schemas/success-schema schemas/measurements-schema)]])

(defn ^:mockable get-measurements
  "Retrieve a list of measurements"
  [opts params]
  (let [url (str (:base-url opts) "/clinician/api/measurements")
        res (client/get url
                        (assoc (utils/opts->request opts)
                               :multi-param-style :array
                               :query-params params))
        post-processor (fn [data] (let [f (if (:validate-output? opts) m/coerce m/decode)]
                                    (f schemas/measurements-schema data utils/prune-map-transformer)))]
    (utils/->output [200] post-processor res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}
                 :report utils/input-validate-fail!})
(clj-kondo/emit!)
 ;; Enable mocks
(utils/make-mockable)

(comment
  ;; Example usage
  (get-measurements {:base-url "https://doccla-dev.oth.io"
                     :validate-output? true
                     :auth {:type :id-secret :id "" :secret ""}}
                    {:max 3}))
