(ns doccla.oth-client.results.blue-alarms.blue-alarms
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.schemas :as schemas]
   [doccla.oth-client.utils :as utils]
   [malli.clj-kondo :as clj-kondo]
   [malli.core :as m]
   [malli.instrument :as mi]))

(def blue-alarm-schema
  [:map
   {:closed true}
   [:acknowledgement
    {:optional true}
    [:map
     [:acknowledged-at [:re schemas/iso-8601-regex]]
     [:acknowledged-by
      [:map
       [:links
        [:map
         [:clinician string?]]]
       [:name string?]]]
     [:closure-notes
      [:vector string?]]
     [:note {:optional true} string?]]]
   [:deadline [:re schemas/iso-8601-regex]]
   [:links
    [:map
     [:patient string?]
     [:questionnaire string?]
     [:questionnaire-definition string?]
     [:self string?]]]
   [:questionnaire-name string?]])

(m/=> get-blue-alarm [:=>
                      [:cat schemas/opts-schema string?]
                      [:or schemas/error-schema (schemas/success-schema blue-alarm-schema)]])

(defn ^:mockable get-blue-alarm
  "Retrieve a specific blue alarm."
  [opts uuid]
  (let [url (str (:base-url opts) "/results/blue-alarms/" uuid)
        res (client/get url (utils/opts->request opts))
        post-processor (fn [data] (let [f (if (:validate-output? opts) m/coerce m/decode)]
                                    (f blue-alarm-schema data utils/prune-map-transformer)))]
    (utils/->output [200] post-processor res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}})
(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)

(comment
  ;; Example usage
  (get-blue-alarm {:base-url "https://doccla-dev.oth.io"
                   :validate-output? true
                   :auth {:type :id-secret :id "" :secret ""}}
                  "351e4e9e7887420481f7b0424028dd94"))