(ns doccla.oth-client.schemas)

(def base-64-regex #"^data:image.+;base64,")
(def simple-date-regex #"^(\d{4})[\-](0[1-9]|1[0-2])[\-]([12]\d|0[1-9]|3[01])$")
(def iso-8601-regex #"^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2})")
(def url-regex #"^http.+[^/]$")
(def ip-address-regex #"^(\d{1,3}\.){3}\d{1,3}$")

(def opts-schema
  [:map
   [:base-url [:re #"^http.+[^/]$"]]
   [:validate-output? :boolean]
   [:auth [:multi
           {:dispatch :type}
           [:token     [:map [:type [:= :token]] [:token string?]]]
           [:id-secret [:map
                        [:type [:= :id-secret]]
                        [:id string?]
                        [:secret string?]]]]]])

(def error-schema
  [:map
   [:code int?]
   [:success? [:= false]]
   [:error string?]])

(defn success-schema
  "Given a response schema, returns a success schema that wraps that response"
  [response-schema]
  [:map
   [:code int?]
   [:success? [:= true]]
   [:response response-schema]])

(def measurement-types-enum
  [:enum "news2" "consciousness" "pulse" "weight" "weight_pound" "temperature" "temperature_fahrenheit" "protein_in_urine" "glucose_in_urine"
   "blood_in_urine" "nitrite_in_urine" "leukocytes_in_urine" "hemoglobin" "crp" "saturation" "lung_function"
   "bloodsugar" "bloodsugar_mg_dl" "daily_steps" "blood_pressure" "pain_scale" "vas_score" "borg_rating" "ctg"
   "height" "respiratory_rate" "peak_flow" "body_cell_mass" "fat_mass" "phase_angle" "fev1" "fev6"
   "inflow_bag_color" "inflow_bag_volume" "outflow_bag_volume" "ultrafiltration_volume" "pump_flow" "pump_speed"
   "pulse_index" "pump_power"])

(def threshold-schema
  [:map
   [:measurement-type measurement-types-enum]
   [:limits
    [:vector
     [:map
      [:name string?]
      [:alert-high {:optional true} some?]
      [:alert-low {:optional true} some?]
      [:warning-high {:optional true} some?]
      [:warning-low {:optional true} some?]]]]
   [:threshold-type
    [:map
     [:point {:optional true}
      [:map
       [:type string?]]]
     [:scope string?]]]])
