(ns doccla.oth-client.measurements.measurement-types
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.utils :as utils]
   [doccla.oth-client.schemas :as schemas]
   [malli.clj-kondo :as clj-kondo]
   [malli.core :as m]
   [malli.instrument :as mi]))

(def measurement-type-schema
  [:map
   [:name string?]
   [:constraints {:optional true}
    [:vector string?]]
   [:values
    [:vector
     [:map
      [:name string?]
      [:unit string?]
      [:type string?]
      [:graph-range {:optional true}
       [:map
        [:from {:optional true} number?]
        [:to {:optional true} number?]
        [:step {:optional true} number?]]]
      [:range {:optional true}
       [:map
        [:min {:optional true} number?]
        [:max {:optional true} number?]]]
      [:options {:optional true}
       [:vector string?]]]]]])

(def measurement-types-schema
  [:map
   [:results
    [:vector measurement-type-schema]]])

(m/=> get-measurement-types [:=>
                             [:cat schemas/opts-schema]
                             [:or schemas/error-schema (schemas/success-schema measurement-types-schema)]])

(defn post-processor
  [opts]
  (fn [data]
    (let [f (if (:validate-output? opts) m/coerce m/decode)]
      (f measurement-types-schema data utils/prune-map-transformer))))

(defn ^:mockable get-measurement-types
  "Retrieve the set of measurement types"
  [opts]
  (let [url (str (:base-url opts) "/measurements/measurement-types")
        req (utils/opts->request opts)
        res (client/get url req)]
    (utils/->output [200] (post-processor opts) res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}})
(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)

(comment
  ;; Example usage
  (get-measurement-types {:base-url "https://doccla-dev.oth.io"
                          :validate-output? true
                          :auth {:type :id-secret :id "" :secret ""}}))
