(ns doccla.oth-client.organizations.patients.metadata
  (:require
   [clj-http.client :as client]
   [doccla.oth-client.schemas :as schemas]
   [doccla.oth-client.utils :as utils]
   [malli.clj-kondo :as clj-kondo]
   [malli.core :as m]
   [malli.instrument :as mi]))

(def metadata-item-schema
  [:map
   [:name string?]
   [:value {:optional true} any?]
   [:type [:or string? [:vector string?]]]
   [:links [:map [:metadata-field string?]]]])

(def metadata-schema
  [:map
   {:closed true}
   [:metadata
    [:vector metadata-item-schema]]
   [:links
    [:map
     [:self string?]
     [:patient string?]]]])

(m/=> get-metadata [:=>
                    [:cat schemas/opts-schema [:or :string :int]]
                    [:or schemas/error-schema (schemas/success-schema metadata-schema)]])

(defn ^:mockable get-metadata
  "Retrieve metadata for a specific patient."
  [opts id]
  (let [res (client/get (str (:base-url opts) "/organizations/patients/" id "/metadata")
                        (utils/opts->request opts))
        post-processor (fn [data] (let [f (if (:validate-output? opts) m/coerce m/decode)]
                                    (f metadata-schema data utils/prune-map-transformer)))]
    (utils/->output [200] post-processor res)))

;; Enable instrumentation so library users get schema checking.
(mi/instrument! {:filters [(-> *ns* str symbol mi/-filter-ns)]
                 :scope #{:input}})
(clj-kondo/emit!)
;; Enable mocks
(utils/make-mockable)

(comment
  (get-metadata (utils/->mock-client {'get-metadata "foo"}) 1)
  (get-metadata {:base-url "https://doccla-dev.oth.io" :validate-output? false :auth {:type :id-secret :id "xxx" :secret "yyy"}} 1))
