# oth-client

A Clojure wrapper around the [OTH API](https://doccla-demo.oth.io/api/docs#resources)

## Usage

1. Create a client that conforms to `oth-client.utils.opts-schema`

``` clojure
(def client
    {:base-url "https://doccla-dev.oth.io"
     :auth     {:type :id-secret :id "" :secret ""}})
```

2. Use the library functions with the client as the first param

``` clojure
(require '[oth-client.patients :as patients])

(patients/get-patients client 5)
```

Note that the client is just a map. 
You can merge your own values on a per-request basis if you'd like.

All library functions are instrumented using malli for both inputs and outputs, meaning
you will get type errors for invalid inputs, as well as malformed OTH responses.
