(defproject com.doccla/oth-client "0.1.13"
  :description "A clojure wrapper around the OTH API"
  :license "private"
  :url "https://github.com/doccla/clj-oth-client"
  :dependencies [[org.clojure/clojure "1.11.1"]
                 [metosin/malli "0.13.0"]
                 [metosin/jsonista "0.3.8"]
                 [camel-snake-kebab "0.4.3"]
                 [clj-http "3.12.3"]]
  :plugins [[com.github.clj-kondo/lein-clj-kondo "0.2.5"]
            [dev.weavejester/lein-cljfmt "0.11.2"]
            [lein-cloverage "1.2.2"]
            [lein-pprint "1.3.2"]]
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "--no-sign"]
                  ["deploy"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :deploy-repositories [["releases" {:url "https://clojars.org/repo"
                                     :username :env/clojars_user
                                     :password  :env/clojars_pass
                                     :sign-releases false}]])
