(ns doccla.oth-client.schemas)

(def measurement-types-enum
  [:enum "news2" "consciousness" "pulse" "weight" "weight_pound" "temperature" "temperature_fahrenheit" "protein_in_urine" "glucose_in_urine"
   "blood_in_urine" "nitrite_in_urine" "leukocytes_in_urine" "hemoglobin" "crp" "saturation" "lung_function"
   "bloodsugar" "bloodsugar_mg_dl" "daily_steps" "blood_pressure" "pain_scale" "vas_score" "borg_rating" "ctg"
   "height" "respiratory_rate" "peak_flow" "body_cell_mass" "fat_mass" "phase_angle" "fev1" "fev6"
   "inflow_bag_color" "inflow_bag_volume" "outflow_bag_volume" "ultrafiltration_volume" "pump_flow" "pump_speed"
   "pulse_index" "pump_power"])

(def threshold-schema
  [:map
   [:measurement-type measurement-types-enum]
   [:limits
    [:vector
     [:map
      [:name string?]
      [:alert-high {:optional true} some?]
      [:alert-low {:optional true} some?]
      [:warning-high {:optional true} some?]
      [:warning-low {:optional true} some?]]]]
   [:threshold-type
    [:map
     [:point {:optional true}
      [:map
       [:type string?]]]
     [:scope string?]]]])